<?php
/**
 * Test Profile URL Output
 * Save as: test-profile-urls.php in your root directory
 * Access: http://localhost/aims/test-profile-urls.php
 */

define('AIMS_ACCESS', true);
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Profile.php';

header('Content-Type: application/json');

// Get user ID from session or use test user
$userId = $_SESSION['user_id'] ?? 9;

try {
    $database = \App\Database::getInstance();
    $db = $database->getConnection();
    $profile = new \App\Profile($db);
    
    $profileData = $profile->getProfile($userId);
    
    // Output the data with debugging info
    $output = [
        'app_url' => APP_URL,
        'profile_picture_from_db' => $profileData['profile_picture'] ?? 'NOT SET',
        'cover_photo_from_db' => $profileData['cover_photo'] ?? 'NOT SET',
        'photos_array' => $profileData['photos'] ?? [],
        'full_profile_data' => $profileData
    ];
    
    echo json_encode($output, JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo json_encode([
        'error' => $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ], JSON_PRETTY_PRINT);
}