<?php
/**
 * ============================================================================
 * learning/videos.php - Video Tutorials Page
 * ============================================================================
 */
define('AIMS_ACCESS', true);
require_once __DIR__ . '/../config/config.php';

requireLogin();

$pageTitle = 'Video Tutorials';

// Sample video data (in production, fetch from database)
$videos = [
    [
        'id' => 1,
        'title' => 'Modern Maize Farming Techniques',
        'description' => 'Learn the latest techniques for growing high-yield maize in Uganda',
        'thumbnail' => APP_URL . '/assets/images/videos/maize-farming.jpg',
        'duration' => '15:30',
        'category' => 'crop_management',
        'views' => 1250,
        'url' => 'https://www.youtube.com/watch?v=example1'
    ],
    [
        'id' => 2,
        'title' => 'Integrated Pest Management for Vegetables',
        'description' => 'Control pests naturally without harmful chemicals',
        'thumbnail' => APP_URL . '/assets/images/videos/pest-control.jpg',
        'duration' => '20:15',
        'category' => 'pest_control',
        'views' => 890,
        'url' => 'https://www.youtube.com/watch?v=example2'
    ],
    [
        'id' => 3,
        'title' => 'Poultry Management for Beginners',
        'description' => 'Start your poultry farm with confidence',
        'thumbnail' => APP_URL . '/assets/images/videos/poultry.jpg',
        'duration' => '18:45',
        'category' => 'livestock',
        'views' => 2100,
        'url' => 'https://www.youtube.com/watch?v=example3'
    ],
    [
        'id' => 4,
        'title' => 'Soil Testing and Improvement',
        'description' => 'Understand your soil and improve its fertility',
        'thumbnail' => APP_URL . '/assets/images/videos/soil-health.jpg',
        'duration' => '12:20',
        'category' => 'soil_health',
        'views' => 750,
        'url' => 'https://www.youtube.com/watch?v=example4'
    ],
    [
        'id' => 5,
        'title' => 'Drip Irrigation Systems',
        'description' => 'Save water and increase yields with drip irrigation',
        'thumbnail' => APP_URL . '/assets/images/videos/irrigation.jpg',
        'duration' => '22:10',
        'category' => 'irrigation',
        'views' => 1500,
        'url' => 'https://www.youtube.com/watch?v=example5'
    ],
    [
        'id' => 6,
        'title' => 'Coffee Harvesting Best Practices',
        'description' => 'Harvest coffee at the right time for maximum quality',
        'thumbnail' => APP_URL . '/assets/images/videos/coffee.jpg',
        'duration' => '16:30',
        'category' => 'harvesting',
        'views' => 980,
        'url' => 'https://www.youtube.com/watch?v=example6'
    ]
];

include_once __DIR__ . '/../includes/meta.php';
include_once __DIR__ . '/../includes/header.php';
?>

<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1">
                        <i class="bi bi-camera-video text-danger"></i> Video Tutorials
                    </h2>
                    <p class="text-muted mb-0">Learn from expert farmers and agricultural professionals</p>
                </div>
                <a href="<?php echo APP_URL; ?>/learning/" class="btn btn-outline-primary">
                    <i class="bi bi-arrow-left"></i> Back to Learning Center
                </a>
            </div>
        </div>
    </div>

    <!-- Search and Filter -->
    <div class="row mb-4">
        <div class="col-md-6 mb-3">
            <div class="input-group">
                <span class="input-group-text"><i class="bi bi-search"></i></span>
                <input type="text" class="form-control" id="videoSearch" placeholder="Search videos...">
            </div>
        </div>
        <div class="col-md-6 mb-3">
            <select class="form-select" id="categoryFilter">
                <option value="">All Categories</option>
                <option value="crop_management">Crop Management</option>
                <option value="pest_control">Pest Control</option>
                <option value="soil_health">Soil Health</option>
                <option value="irrigation">Irrigation</option>
                <option value="harvesting">Harvesting</option>
                <option value="livestock">Livestock</option>
            </select>
        </div>
    </div>

    <!-- Videos Grid -->
    <div class="row" id="videosContainer">
        <?php foreach ($videos as $video): ?>
            <div class="col-md-6 col-lg-4 mb-4 video-card" data-category="<?php echo $video['category']; ?>" data-title="<?php echo strtolower($video['title']); ?>">
                <div class="card h-100 border-0 shadow-sm hover-lift">
                    <div class="position-relative">
                        <div class="ratio ratio-16x9">
                            <div class="bg-dark d-flex align-items-center justify-content-center">
                                <i class="bi bi-play-circle text-white" style="font-size: 4rem; opacity: 0.8;"></i>
                            </div>
                        </div>
                        <span class="position-absolute bottom-0 end-0 m-2 badge bg-dark">
                            <i class="bi bi-clock"></i> <?php echo $video['duration']; ?>
                        </span>
                        <span class="position-absolute top-0 start-0 m-2 badge bg-danger">
                            <i class="bi bi-camera-video"></i> Video
                        </span>
                    </div>
                    
                    <div class="card-body">
                        <div class="mb-2">
                            <span class="badge bg-primary">
                                <?php echo ucwords(str_replace('_', ' ', $video['category'])); ?>
                            </span>
                            <small class="text-muted ms-2">
                                <i class="bi bi-eye"></i> <?php echo number_format($video['views']); ?> views
                            </small>
                        </div>
                        
                        <h5 class="card-title"><?php echo htmlspecialchars($video['title']); ?></h5>
                        <p class="card-text text-muted small">
                            <?php echo htmlspecialchars($video['description']); ?>
                        </p>
                    </div>
                    
                    <div class="card-footer bg-transparent border-top-0">
                        <button class="btn btn-danger w-100" onclick="watchVideo('<?php echo $video['url']; ?>', '<?php echo addslashes($video['title']); ?>')">
                            <i class="bi bi-play-fill"></i> Watch Now
                        </button>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- No Results Message -->
    <div class="row d-none" id="noResults">
        <div class="col-12">
            <div class="alert alert-info text-center">
                <i class="bi bi-info-circle"></i> No videos found matching your search.
            </div>
        </div>
    </div>
</div>

<!-- Video Player Modal -->
<div class="modal fade" id="videoModal" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="videoTitle">Video Player</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-0">
                <div class="ratio ratio-16x9">
                    <iframe id="videoPlayer" src="" frameborder="0" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.hover-lift {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.hover-lift:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15) !important;
}

.video-card {
    transition: opacity 0.3s ease;
}
</style>

<script>
// Watch video
function watchVideo(url, title) {
    $('#videoTitle').text(title);
    $('#videoPlayer').attr('src', url);
    const modal = new bootstrap.Modal(document.getElementById('videoModal'));
    modal.show();
}

// Stop video when modal closes
$('#videoModal').on('hidden.bs.modal', function () {
    $('#videoPlayer').attr('src', '');
});

// Search and filter functionality
$(document).ready(function() {
    function filterVideos() {
        const searchTerm = $('#videoSearch').val().toLowerCase();
        const category = $('#categoryFilter').val();
        let visibleCount = 0;

        $('.video-card').each(function() {
            const title = $(this).data('title');
            const videoCategory = $(this).data('category');
            
            const matchesSearch = searchTerm === '' || title.includes(searchTerm);
            const matchesCategory = category === '' || videoCategory === category;
            
            if (matchesSearch && matchesCategory) {
                $(this).show();
                visibleCount++;
            } else {
                $(this).hide();
            }
        });

        if (visibleCount === 0) {
            $('#noResults').removeClass('d-none');
        } else {
            $('#noResults').addClass('d-none');
        }
    }

    $('#videoSearch').on('keyup', filterVideos);
    $('#categoryFilter').on('change', filterVideos);
});
</script>

<?php
include_once __DIR__ . '/../includes/footer.php';
include_once __DIR__ . '/../includes/bottom-nav.php';
?>
