<?php
/**
 * ============================================================================
 * friends/mutual-friends.php - View Mutual Friends
 * ============================================================================
 */

define('AIMS_ACCESS', true);
require_once __DIR__ . '/../config/config.php';

requireLogin();

$userId = getUserId();
$friendId = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$friendId) {
    redirect('/friends/index.php');
}

// Get database connection
$database = new Database();
$db = $database->getConnection();
$friendshipClass = new \App\Friendship($db);

// Get friend info
$stmt = $db->prepare("SELECT full_name, profile_picture FROM users WHERE id = ?");
$stmt->execute([$friendId]);
$friend = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$friend) {
    redirect('/friends/index.php');
}

// Get mutual friends
$mutualFriends = $friendshipClass->getMutualFriends($userId, $friendId);

$pageTitle = 'Mutual Friends with ' . $friend['full_name'];
include_once __DIR__ . '/../includes/meta.php';
include_once __DIR__ . '/../includes/header.php';
?>

<style>
    .mutual-container {
        background: #f0f2f5;
        min-height: 100vh;
        padding: 2rem 0;
    }
    
    .page-header {
        background: white;
        padding: 1.5rem;
        border-radius: 8px;
        margin-bottom: 1.5rem;
    }
    
    .friend-card {
        background: white;
        border-radius: 8px;
        overflow: hidden;
        transition: all 0.3s;
        cursor: pointer;
        box-shadow: 0 1px 2px rgba(0,0,0,0.1);
    }
    
    .friend-card:hover {
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        transform: translateY(-2px);
    }
    
    .friend-card-image {
        width: 100%;
        height: 200px;
        object-fit: cover;
        background: #f0f2f5;
    }
    
    .friend-card-body {
        padding: 1rem;
    }
    
    .friend-name {
        font-weight: 600;
        font-size: 1rem;
        margin-bottom: 0.5rem;
        color: #050505;
    }
</style>

<div class="mutual-container">
    <div class="container">
        <div class="page-header">
            <a href="profile.php?id=<?= $friendId ?>" class="btn btn-link text-decoration-none mb-3">
                <i class="bi bi-arrow-left"></i> Back to Profile
            </a>
            <h4 style="font-weight: 700;">
                Mutual Friends with <?= htmlspecialchars($friend['full_name']) ?>
            </h4>
            <p class="text-muted mb-0"><?= count($mutualFriends) ?> mutual friends</p>
        </div>
        
        <?php if (count($mutualFriends) > 0): ?>
            <div class="row g-3">
                <?php foreach ($mutualFriends as $mutual): ?>
                    <div class="col-lg-3 col-md-4 col-sm-6">
                        <div class="friend-card" onclick="window.location.href='profile.php?id=<?= $mutual['id'] ?>'">
                            <img src="<?= APP_URL . '/' . htmlspecialchars($mutual['profile_picture']) ?>" 
                                 alt="<?= htmlspecialchars($mutual['full_name']) ?>" 
                                 class="friend-card-image">
                            <div class="friend-card-body">
                                <div class="friend-name"><?= htmlspecialchars($mutual['full_name']) ?></div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="text-center py-5" style="background: white; border-radius: 8px;">
                <i class="bi bi-people" style="font-size: 4rem; color: #d8dadf;"></i>
                <h5 class="mt-3">No Mutual Friends</h5>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php
include_once __DIR__ . '/../includes/footer.php';
include_once __DIR__ . '/../includes/bottom-nav.php';
?>