<?php
/**
 * friends/ajax/respond-request.php
 * Respond to Friend Request AJAX Handler
 */

define('AIMS_ACCESS', true);
require_once __DIR__ . '/../../config/config.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Please log in']);
    exit;
}

$userId = getUserId();
$requestId = filter_input(INPUT_POST, 'request_id', FILTER_VALIDATE_INT);
$action = filter_input(INPUT_POST, 'action', FILTER_SANITIZE_STRING);

if (!$requestId || !in_array($action, ['accept', 'reject'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid parameters']);
    exit;
}

// Get database connection
$database = new Database();
$db = $database->getConnection();
$friendship = new \App\Friendship($db);

if ($action === 'accept') {
    $result = $friendship->acceptRequest($requestId, $userId);
} else {
    $result = $friendship->deleteRequest($requestId, $userId);
}

echo json_encode($result);
?>