<?php
/**
 * ============================================================================
 * farm/add-enterprise.php - Add New Enterprise
 * ============================================================================
 */
define('AIMS_ACCESS', true);
require_once __DIR__ . '/../config/config.php';

requireLogin();

if (getUserType() !== 'farmer') {
    redirect('/dashboard/', 'Only farmers can add enterprises', 'error');
}

$pageTitle = 'Add Enterprise';
$userId = getUserId();

// Get database connection
$database = new Database();
$db = $database->getConnection();

// Get user's farm
$farmClass = new \App\Farm($db);
$farms = $farmClass->getUserFarms($userId);

if (empty($farms)) {
    redirect('/farm/', 'Please create a farm first', 'error');
}

$farm = $farms[0];

// Handle form submission
if (isPost()) {
    $enterpriseClass = new \App\Enterprise($db);
    
    $data = [
        'enterprise_type' => $_POST['enterprise_type'],
        'enterprise_name' => $_POST['enterprise_name'] ?? '',
        'size_acres' => $_POST['size_acres'] ?? 0,
        'quantity' => $_POST['quantity'] ?? 0,
        'planting_date' => $_POST['planting_date'] ?? null,
        'expected_harvest_date' => $_POST['expected_harvest_date'] ?? null,
        'status' => $_POST['status'] ?? 'planning',
        'notes' => $_POST['notes'] ?? ''
    ];
    
    $result = $enterpriseClass->create($farm['id'], $data);
    
    if ($result['success']) {
        redirect('/farm/', $result['message'], 'success');
    } else {
        setFlashMessage($result['message'], 'error');
    }
}

include_once __DIR__ . '/../includes/meta.php';
include_once __DIR__ . '/../includes/header.php';
?>

<div class="container-fluid py-4">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h4 class="mb-0">
                        <i class="bi bi-plus-circle text-success"></i> Add New Enterprise
                    </h4>
                </div>
                <div class="card-body p-4">
                    <form method="POST">
                        <!-- Enterprise Type -->
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Enterprise Type <span class="text-danger">*</span></label>
                            <select class="form-select" name="enterprise_type" required>
                                <option value="">Select Type</option>
                                <option value="sugar_cane">Sugar Cane</option>
                                <option value="poultry">Poultry</option>
                                <option value="maize">Maize</option>
                                <option value="vegetables">Vegetables</option>
                                <option value="coffee">Coffee</option>
                                <option value="beans">Beans</option>
                                <option value="cassava">Cassava</option>
                                <option value="bananas">Bananas</option>
                                <option value="dairy">Dairy</option>
                                <option value="piggery">Piggery</option>
                                <option value="other">Other</option>
                            </select>
                        </div>

                        <!-- Enterprise Name -->
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Enterprise Name (Optional)</label>
                            <input type="text" class="form-control" name="enterprise_name" 
                                   placeholder="e.g., North Field Maize">
                        </div>

                        <!-- Size -->
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Size (Acres)</label>
                            <input type="number" class="form-control" name="size_acres" 
                                   step="0.01" min="0" placeholder="0.00">
                            <small class="text-muted">
                                Available: <?php echo number_format($farm['total_acres'] - ($farm['used_acres'] ?? 0), 1); ?> acres
                            </small>
                        </div>

                        <!-- Quantity -->
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Quantity (e.g., birds, plants)</label>
                            <input type="number" class="form-control" name="quantity" 
                                   min="0" placeholder="0">
                        </div>

                        <!-- Dates -->
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Planting Date</label>
                                <input type="date" class="form-control" name="planting_date">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Expected Harvest</label>
                                <input type="date" class="form-control" name="expected_harvest_date">
                            </div>
                        </div>

                        <!-- Status -->
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Status</label>
                            <select class="form-select" name="status">
                                <option value="planning">Planning</option>
                                <option value="planted">Planted</option>
                                <option value="growing">Growing</option>
                                <option value="harvesting">Harvesting</option>
                                <option value="completed">Completed</option>
                            </select>
                        </div>

                        <!-- Notes -->
                        <div class="mb-4">
                            <label class="form-label fw-semibold">Notes</label>
                            <textarea class="form-control" name="notes" rows="3" 
                                      placeholder="Additional notes..."></textarea>
                        </div>

                        <!-- Buttons -->
                        <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                            <a href="<?php echo APP_URL; ?>/farm/" class="btn btn-outline-secondary">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-check-circle"></i> Add Enterprise
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
include_once __DIR__ . '/../includes/footer.php';
include_once __DIR__ . '/../includes/bottom-nav.php';
?>
