<?php
/**
 * ============================================================================
 * extension/includes/helpers.php
 * Extension Helper Functions
 * ============================================================================
 */

/**
 * Redirect helper function
 */
if (!function_exists('redirectTo')) {
    function redirectTo($url, $message = null, $type = 'info') {
        if ($message) {
            setFlashMessage($message, $type);
        }
        header('Location: ' . APP_URL . $url);
        exit();
    }
}

/**
 * Time ago helper
 */
if (!function_exists('timeAgo')) {
    function timeAgo($datetime) {
        $timestamp = strtotime($datetime);
        $difference = time() - $timestamp;
        
        $periods = [
            'year' => 31556926,
            'month' => 2629743,
            'week' => 604800,
            'day' => 86400,
            'hour' => 3600,
            'minute' => 60,
            'second' => 1
        ];
        
        foreach ($periods as $key => $value) {
            if ($difference >= $value) {
                $time = floor($difference / $value);
                return $time . ' ' . $key . ($time > 1 ? 's' : '') . ' ago';
            }
        }
        
        return 'Just now';
    }
}

/**
 * Format currency
 */
if (!function_exists('formatCurrency')) {
    function formatCurrency($amount, $currency = 'UGX') {
        return $currency . ' ' . number_format($amount, 0);
    }
}

/**
 * Sanitize output
 */
if (!function_exists('e')) {
    function e($string) {
        return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
    }
}

/**
 * Get status badge color
 */
if (!function_exists('getStatusBadge')) {
    function getStatusBadge($status) {
        $badges = [
            'scheduled' => 'primary',
            'ongoing' => 'info',
            'completed' => 'success',
            'cancelled' => 'danger',
            'draft' => 'secondary',
            'submitted' => 'warning',
            'approved' => 'success',
            'rejected' => 'danger',
            'active' => 'success',
            'inactive' => 'secondary',
            'pending' => 'warning'
        ];
        
        return $badges[$status] ?? 'secondary';
    }
}

/**
 * Format service type
 */
if (!function_exists('formatServiceType')) {
    function formatServiceType($type) {
        $types = [
            'farm_visit' => 'Farm Visit',
            'training' => 'Training Session',
            'consultation' => 'Consultation',
            'demonstration' => 'Demonstration',
            'field_day' => 'Field Day',
            'workshop' => 'Workshop'
        ];
        
        return $types[$type] ?? ucfirst(str_replace('_', ' ', $type));
    }
}

/**
 * Get service icon
 */
if (!function_exists('getServiceIcon')) {
    function getServiceIcon($type) {
        $icons = [
            'farm_visit' => 'house-door',
            'training' => 'book',
            'consultation' => 'chat-dots',
            'demonstration' => 'eye',
            'field_day' => 'sun',
            'workshop' => 'people'
        ];
        
        return $icons[$type] ?? 'calendar-event';
    }
}