# AIMS Platform - Entity-Relationship Diagram

## Agricultural Information and Market Linkage System

### Student: Musumba Jonathan (21/BCS/010/UMC)

### Institution: Metropolitan International University

---

## 1. HIGH-LEVEL ER DIAGRAM OVERVIEW

┌─────────────────────────────────────────────────────────────────┐
│                    AIMS PLATFORM - CORE ENTITIES                 │
└─────────────────────────────────────────────────────────────────┘

┌──────────────┐         ┌──────────────┐         ┌──────────────┐
│    USERS     │────────>│   REGIONS    │         │    FARMS     │
│              │         │              │         │              │
│ • id (PK)    │         │ • id (PK)    │         │ • id (PK)    │
│ • phone      │         │ • name       │         │ • user_id    │
│ • password   │         │ • code       │         │ • name       │
│ • full_name  │         └──────┬───────┘         │ • acres      │
│ • email      │                │                 │ • location   │
│ • user_type  │         ┌──────▼───────┐         └──────┬───────┘
│ • region_id  │────────>│  DISTRICTS   │                │
│ • district_id│         │              │         ┌──────▼───────┐
│ • verified   │         │ • id (PK)    │         │ ENTERPRISES  │
│ • active     │         │ • region_id  │         │              │
└──────┬───────┘         │ • name       │         │ • id (PK)    │
       │                 │ • code       │         │ • farm_id    │
       │                 └──────┬───────┘         │ • type       │
       │                        │                 │ • size       │
       │                 ┌──────▼───────┐         │ • status     │
       │                 │ SUBCOUNTIES  │         └──────┬───────┘
       │                 │              │                │
       │                 │ • id (PK)    │         ┌──────▼───────┐
       │                 │ • district_id│         │  PRODUCTS    │
       │                 │ • name       │         │              │
       │                 └──────┬───────┘         │ • id (PK)    │
       │                        │                 │ • seller_id  │
       │                 ┌──────▼───────┐         │ • enterprise │
       │                 │   PARISHES   │         │ • name       │
       │                 │              │         │ • category   │
       │                 │ • id (PK)    │         │ • quantity   │
       │                 │ • subcounty  │         │ • price      │
       │                 │ • name       │         │ • status     │
       │                 └──────┬───────┘         └──────────────┘
       │                        │
       │                 ┌──────▼───────┐
       │                 │   VILLAGES   │
       │                 │              │
       │                 │ • id (PK)    │
       │                 │ • parish_id  │
       │                 │ • name       │
       │                 └──────────────┘
       │
       │
       ├────────────────────────────────────────────────────────┐
       │                                                        │
       ▼                                                        ▼
┌──────────────┐                                        ┌──────────────┐
│ USER PROFILES│                                        │ FRIENDSHIPS  │
│              │                                        │              │
│ • id (PK)    │                                        │ • id (PK)    │
│ • user_id    │                                        │ • user_id    │
│ • bio        │                                        │ • friend_id  │
│ • tagline    │                                        │ • status     │
│ • education  │                                        │ • requested  │
│ • experience │                                        │ • accepted   │
└──────────────┘                                        └──────────────┘

---

## 2. USER MANAGEMENT & AUTHENTICATION

┌─────────────────────────────────────────────────────────────┐
│              USER AUTHENTICATION & ROLES                    │
└─────────────────────────────────────────────────────────────┘

                    ┌──────────────┐
                    │    USERS     │
                    │              │
                    │ • id (PK)    │
                    │ • phone      │
                    │ • password   │
                    │ • user_type  │──┐
                    └──────┬───────┘  │
                           │          │
        ┌──────────────────┼──────────┼─────────────────┐
        │                  │          │                 │
        ▼                  ▼          ▼                 ▼
┌──────────────┐  ┌──────────────┐  ┌──────────────┐  ┌──────────────┐
│BUYER PROFILES│  │EXTENSION OFF │  │ADMIN ROLES   │  │FARMER (Base) │
│              │  │PROFILES      │  │              │  │              │
│• id (PK)     │  │• id (PK)     │  │• id (PK)     │  │• Uses core   │
│• user_id (FK)│  │• user_id (FK)│  │• role_name   │  │  user table  │
│• buyer_type  │  │• employee_id │  │• role_level  │  │              │
│• business    │  │• organization│  │• description │  │              │
│• tax_id      │  │• qualification│ │• is_active   │  │              │
│• verified    │  │• specialization│ └──────┬───────┘  │              │
└──────┬───────┘  └──────┬───────┘         │          └──────────────┘
       │                 │                 │
       │                 │                 ▼
       │                 │          ┌──────────────┐
       │                 │          │ROLE PERMS    │
       │                 │          │              │
       │                 │          │• id (PK)     │
       │                 │          │• role_id (FK)│
       │                 │          │• permission  │
       │                 │          └──────────────┘
       │                 │
       ▼                 ▼
┌──────────────┐  ┌──────────────┐
│USER APPROVALS│  │EXTENSION     │
│              │  │ASSIGNMENTS   │
│• id (PK)     │  │              │
│• user_id (FK)│  │• id (PK)     │
│• user_type   │  │• user_id (FK)│
│• status      │  │• role_id (FK)│
│• docs        │  │• level       │
│• approved_by │  │• region      │
│• approved_at │  │• supervisor  │
└──────────────┘  └──────────────┘

┌──────────────────────────────────────────┐
│OTP VERIFICATIONS                         │
│                                          │
│• id (PK)                                 │
│• phone_number                            │
│• otp_code                                │
│• purpose (registration|login|reset)      │
│• is_verified                             │
│• expires_at                              │
└──────────────────────────────────────────┘

---

## 3. MARKETPLACE & PRODUCTS

┌──────────────┐         ┌──────────────┐         ┌──────────────┐
│  PRODUCTS    │────────>│   ORDERS     │<────────│   REVIEWS    │
│              │         │              │         │              │
│ • id (PK)    │         │ • id (PK)    │         │ • id (PK)    │
│ • seller_id  │         │ • order_num  │         │ • reviewer   │
│ • enterprise │         │ • product_id │         │ • reviewed   │
│ • name       │         │ • buyer_id   │         │ • order_id   │
│ • category   │         │ • seller_id  │         │ • rating     │
│ • quantity   │         │ • quantity   │         │ • review_text│
│ • price      │         │ • total      │         │ • created_at │
│ • images     │         │ • status     │         └──────────────┘
│ • status     │         │ • payment    │
│ • views      │         └──────┬───────┘
└──────┬───────┘                │
       │                        │
       ▼                        ▼
┌──────────────┐         ┌──────────────┐
│ FAVORITES    │         │SUPPLIER      │
│              │         │RATINGS       │
│ • id (PK)    │         │              │
│ • user_id    │         │ • id (PK)    │
│ • product_id │         │ • buyer_id   │
│ • created_at │         │ • supplier_id│
└──────────────┘         │ • order_id   │
                         │ • quality    │
┌──────────────┐         │ • delivery   │
│PRODUCT       │         │ • comm_rating│
│INQUIRIES     │         │ • overall    │
│              │         └──────────────┘
│ • id (PK)    │
│ • product_id │         ┌──────────────┐
│ • buyer_id   │         │BULK ORDERS   │
│ • message    │         │              │
│ • status     │         │ • id (PK)    │
└──────────────┘         │ • buyer_id   │
                         │ • title      │
                         │ • product    │
                         │ • quantity   │
                         │ • budget     │
                         │ • deadline   │
                         │ • status     │
                         └──────┬───────┘
                                │
                                ▼
                         ┌──────────────┐
                         │BULK ORDER    │
                         │BIDS          │
                         │              │
                         │ • id (PK)    │
                         │ • order_id   │
                         │ • farmer_id  │
                         │ • quantity   │
                         │ • price      │
                         │ • status     │
                         └──────────────┘

## 4. PRICE INTELLIGENCE SYSTEM

┌─────────────────────────────────────────────────────────────┐
│              PRICE INTELLIGENCE & ALERTS                    │
└─────────────────────────────────────────────────────────────┘

┌──────────────┐         ┌──────────────┐         ┌──────────────┐
│MARKET PRICES │────────>│PRICE HISTORY │────────>│SEASONAL      │
│              │         │              │         │PATTERNS      │
│ • id (PK)    │         │ • id (PK)    │         │              │
│ • product    │         │ • product    │         │ • id (PK)    │
│ • location   │         │ • location   │         │ • product    │
│ • price      │         │ • price      │         │ • month      │
│ • unit       │         │ • date       │         │ • avg_index  │
│ • source     │         │ • change     │         │ • volatility │
│ • date       │         │ • percent    │         └──────────────┘
└──────┬───────┘         └──────────────┘
       │
       ▼
┌──────────────┐         ┌──────────────┐         ┌──────────────┐
│PRICE ALERTS  │────────>│PRICE ALERT   │         │PRICE         │
│              │         │NOTIFICATIONS │         │PREDICTIONS   │
│ • id (PK)    │         │              │         │              │
│ • user_id    │         │ • id (PK)    │         │ • id (PK)    │
│ • product    │         │ • alert_id   │         │ • product    │
│ • target     │         │ • user_id    │         │ • pred_date  │
│ • condition  │         │ • trigger    │         │ • min_price  │
│ • is_active  │         │ • sent       │         │ • avg_price  │
└──────────────┘         └──────────────┘         │ • max_price  │
                                                   │ • confidence │
                                                   └──────────────┘

┌──────────────┐         ┌──────────────┐
│PRICE REPORTS │         │PRICE SOURCES │
│              │         │              │
│ • id (PK)    │         │ • id (PK)    │
│ • user_id    │         │ • name       │
│ • product    │         │ • type       │
│ • location   │         │ • reliability│
│ • price      │         │ • is_active  │
│ • verified   │         └──────────────┘
└──────────────┘

## 5. COMMUNICATION & SOCIAL FEATURES

┌─────────────────────────────────────────────────────────────┐
│             COMMUNICATION SYSTEM                            │
└─────────────────────────────────────────────────────────────┘

┌──────────────┐         ┌──────────────┐         ┌──────────────┐
│    CHATS     │<────────│CHAT MEMBERS  │────────>│   MESSAGES   │
│              │         │              │         │              │
│ • id (PK)    │         │ • id (PK)    │         │ • id (PK)    │
│ • chat_type  │         │ • chat_id    │         │ • chat_id    │
│ • name       │         │ • user_id    │         │ • sender_id  │
│ • avatar     │         │ • role       │         │ • type       │
│ • created_by │         │ • joined_at  │         │ • content    │
│ • created_at │         │ • last_read  │         │ • media_url  │
└──────┬───────┘         └──────────────┘         │ • created_at │
       │                                           └──────┬───────┘
       │                                                  │
       ▼                                                  ▼
┌──────────────┐                                  ┌──────────────┐
│CHAT          │                                  │MESSAGE       │
│ENCRYPTION    │                                  │ATTACHMENTS   │
│KEYS          │                                  │              │
│              │                                  │ • id (PK)    │
│ • id (PK)    │                                  │ • message_id │
│ • chat_id    │                                  │ • file_name  │
│ • user_id    │                                  │ • file_type  │
│ • encrypted  │                                  │ • file_url   │
└──────────────┘                                  └──────────────┘

                                                  ┌──────────────┐
                                                  │MESSAGE       │
                                                  │REACTIONS     │
                                                  │              │
                                                  │ • id (PK)    │
                                                  │ • message_id │
                                                  │ • user_id    │
                                                  │ • reaction   │
                                                  └──────────────┘
---

## 6. FARM MANAGEMENT

┌─────────────────────────────────────────────────────────────┐
│                FARM MANAGEMENT SYSTEM                       │
└─────────────────────────────────────────────────────────────┘

┌──────────────┐         ┌──────────────┐         ┌──────────────┐
│    FARMS     │────────>│ ENTERPRISES  │────────>│TRANSACTIONS  │
│              │         │              │         │              │
│ • id (PK)    │         │ • id (PK)    │         │ • id (PK)    │
│ • user_id    │         │ • farm_id    │         │ • user_id    │
│ • name       │         │ • type       │         │ • enterprise │
│ • acres      │         │ • size       │         │ • type       │
│ • location   │         │ • planting   │         │ • category   │
│ • soil_type  │         │ • harvest    │         │ • amount     │
│ • water      │         │ • status     │         │ • date       │
└──────────────┘         │ • notes      │         └──────────────┘
                         └──────┬───────┘
                                │
                                ▼
                         ┌──────────────┐
                         │USER FARMING  │
                         │REMINDERS     │
                         │              │
                         │ • id (PK)    │
                         │ • user_id    │
                         │ • enterprise │
                         │ • schedule   │
                         │ • title      │
                         │ • date       │
                         │ • time       │
                         │ • status     │
                         └──────────────┘

---

## 7. EXTENSION SERVICES

┌─────────────────────────────────────────────────────────────┐
│              EXTENSION SERVICES SYSTEM                      │
└─────────────────────────────────────────────────────────────┘

┌──────────────┐         ┌──────────────┐         ┌──────────────┐
│EXTENSION     │────────>│EXTENSION     │────────>│SERVICE       │
│ASSIGNMENTS   │         │SERVICES      │         │PARTICIPANTS  │
│              │         │              │         │              │
│ • id (PK)    │         │ • id (PK)    │         │ • id (PK)    │
│ • user_id    │         │ • officer_id │         │ • service_id │
│ • role_id    │         │ • type       │         │ • user_id    │
│ • level      │         │ • title      │         │ • attendance │
│ • region     │         │ • location   │         │ • feedback   │
│ • district   │         │ • date       │         │ • rating     │
│ • supervisor │         │ • time       │         └──────────────┘
│ • is_active  │         │ • max_parts  │
└──────┬───────┘         │ • status     │
       │                 └──────────────┘
       │
       ▼
┌──────────────┐         ┌──────────────┐         ┌──────────────┐
│EXTENSION     │         │EXTENSION     │         │EXTENSION     │
│ROLES         │         │REPORTS       │         │RESOURCES     │
│              │         │              │         │              │
│ • id (PK)    │         │ • id (PK)    │         │ • id (PK)    │
│ • name       │         │ • submitted  │         │ • created_by │
│ • level      │         │ • assignment │         │ • type       │
│ • org_type   │         │ • type       │         │ • title      │
│ • permissions│         │ • period     │         │ • content    │
│ • is_active  │         │ • farmers    │         │ • target     │
└──────────────┘         │ • services   │         │ • is_public  │
                         │ • status     │         └──────────────┘
                         └──────────────┘

┌──────────────┐
│EXTENSION     │
│ACTIVITY LOG  │
│              │
│ • id (PK)    │
│ • user_id    │
│ • assignment │
│ • type       │
│ • description│
│ • farmers    │
│ • date       │
└──────────────┘

---

## 8. AI ASSISTANT & LEARNING

┌─────────────────────────────────────────────────────────────┐
│            AI ASSISTANT & KNOWLEDGE BASE                    │
└─────────────────────────────────────────────────────────────┘

┌──────────────┐         ┌──────────────┐         ┌──────────────┐
│AI            │────────>│AI SESSION    │────────>│AI KNOWLEDGE  │
│CONVERSATIONS │         │CONTEXT       │         │SOURCES       │
│              │         │              │         │              │
│ • id (PK)    │         │ • id (PK)    │         │ • id (PK)    │
│ • user_id    │         │ • session_id │         │ • type       │
│ • session_id │         │ • user_id    │         │ • name       │
│ • message    │         │ • topics     │         │ • query      │
│ • response   │         │ • context    │         │ • template   │
│ • context    │         │ • last_topic │         │ • priority   │
│ • language   │         └──────────────┘         │ • is_active  │
│ • source     │                                   └──────────────┘
└──────┬───────┘
       │
       ▼
┌──────────────┐         ┌──────────────┐
│AI            │         │AI LEARNED    │
│CONVERSATION  │         │PATTERNS      │
│FEEDBACK      │         │              │
│              │         │ • id (PK)    │
│ • id (PK)    │         │ • question   │
│ • conv_id    │         │ • response   │
│ • user_id    │         │ • language   │
│ • rating     │         │ • source     │
│ • feedback   │         │ • usage_cnt  │
└──────────────┘         │ • success    │
                         │ • is_active  │
                         └──────────────┘

┌──────────────┐         ┌──────────────┐         ┌──────────────┐
│AGRICULTURAL  │         │CROP DISEASES │         │CROP          │
│TIPS          │         │              │         │VARIETIES     │
│              │         │ • id (PK)    │         │              │
│ • id (PK)    │         │ • name       │         │ • id (PK)    │
│ • title      │         │ • scientific │         │ • crop_type  │
│ • content    │         │ • crop_type  │         │ • variety    │
│ • category   │         │ • category   │         │ • description│
│ • crop_type  │         │ • symptoms   │         │ • maturity   │
│ • season     │         │ • treatment  │         │ • yield      │
│ • language   │         │ • severity   │         │ • soil_req   │
│ • is_public  │         │ • images     │         │ • climate    │
└──────────────┘         └──────────────┘         └──────────────┘

┌──────────────┐         ┌──────────────┐
│FARMING       │         │LEARNING      │
│SCHEDULES     │         │PROGRESS      │
│              │         │              │
│ • id (PK)    │         │ • id (PK)    │
│ • crop_type  │         │ • user_id    │
│ • activity   │         │ • content_type│
│ • title      │         │ • content_id │
│ • timing     │         │ • status     │
│ • week_from  │         │ • progress   │
│ • priority   │         │ • rating     │
└──────────────┘         └──────────────┘

---

## 9. SOCIAL & COMMUNITY FEATURES

┌─────────────────────────────────────────────────────────────┐
│              SOCIAL & COMMUNITY FEATURES                    │
└─────────────────────────────────────────────────────────────┘

┌──────────────┐         ┌──────────────┐         ┌──────────────┐
│    POSTS     │────────>│POST COMMENTS │────────>│COMMENT LIKES │
│              │         │              │         │              │
│ • id (PK)    │         │ • id (PK)    │         │ • id (PK)    │
│ • user_id    │         │ • post_id    │         │ • comment_id │
│ • content    │         │ • user_id    │         │ • user_id    │
│ • media_urls │         │ • parent_id  │         │ • created_at │
│ • post_type  │         │ • content    │         └──────────────┘
│ • visibility │         │ • likes      │
│ • likes      │         └──────────────┘
│ • comments   │
│ • shares     │
└──────┬───────┘
       │
       ▼
┌──────────────┐
│  POST LIKES  │
│              │
│ • id (PK)    │
│ • post_id    │
│ • user_id    │
│ • created_at │
└──────────────┘

┌──────────────┐         ┌──────────────┐         ┌──────────────┐
│    GROUPS    │────────>│GROUP MEMBERS │────────>│GROUP POSTS   │
│              │         │              │         │              │
│ • id (PK)    │         │ • id (PK)    │         │ • id (PK)    │
│ • name       │         │ • group_id   │         │ • group_id   │
│ • description│         │ • user_id    │         │ • user_id    │
│ • avatar     │         │ • role       │         │ • content    │
│ • privacy    │         │ • status     │         │ • media_urls │
│ • category   │         │ • joined_at  │         │ • is_pinned  │
│ • created_by │         └──────────────┘         └──────────────┘
└──────────────┘

┌──────────────┐         ┌──────────────┐
│USER STORIES  │         │STORY VIEWS   │
│              │         │              │
│ • id (PK)    │         │ • id (PK)    │
│ • user_id    │         │ • story_id   │
│ • media_type │         │ • viewer_id  │
│ • media_url  │         │ • viewed_at  │
│ • expires_at │         └──────────────┘
└──────────────┘

┌──────────────┐         ┌──────────────┐
│PROFILE       │         │PHOTO LIKES   │
│PHOTOS        │         │              │
│              │         │ • id (PK)    │
│ • id (PK)    │         │ • photo_id   │
│ • user_id    │         │ • user_id    │
│ • photo_url  │         │ • created_at │
│ • photo_type │         └──────────────┘
│ • caption    │
│ • is_current │         ┌──────────────┐
│ • likes      │         │PHOTO COMMENTS│
│ • comments   │         │              │
└──────────────┘         │ • id (PK)    │
                         │ • photo_id   │
                         │ • user_id    │
                         │ • comment    │
                         └──────────────┘

---

## 10. BUYER-SPECIFIC FEATURES

┌─────────────────────────────────────────────────────────────┐
│                 BUYER FEATURES                              │
└─────────────────────────────────────────────────────────────┘

┌──────────────┐         ┌──────────────┐         ┌──────────────┐
│PURCHASE      │────────>│QUOTE         │────────>│FARMING       │
│REQUESTS      │         │RESPONSES     │         │CONTRACTS     │
│              │         │              │         │              │
│ • id (PK)    │         │ • id (PK)    │         │ • id (PK)    │
│ • buyer_id   │         │ • request_id │         │ • buyer_id   │
│ • product    │         │ • seller_id  │         │ • farmer_id  │
│ • quantity   │         │ • quoted_qty │         │ • product    │
│ • specs      │         │ • price      │         │ • quantity   │
│ • deadline   │         │ • delivery   │         │ • price      │
│ • status     │         │ • status     │         │ • start_date │
└──────────────┘         └──────────────┘         │ • end_date   │
                                                   │ • status     │
                                                   └──────┬───────┘
                                                          │
┌──────────────┐                                          ▼
│BUYER         │                                   ┌──────────────┐
│PREFERENCES   │                                   │CONTRACT      │
│              │                                   │DELIVERIES    │
│ • id (PK)    │                                   │              │
│ • buyer_id   │                                   │ • id (PK)    │
│ • categories │                                   │ • contract_id│
│ • regions    │                                   │ • delivery#  │
│ • min_quality│                                   │ • quantity   │
│ • notify_sms │                                   │ • date       │
│ • notify_push│                                   │ • quality    │
└──────────────┘                                   │ • amount     │
                                                   │ • status     │
┌──────────────┐                                   └──────────────┘
│BUYER         │
│WATCHLIST     │
│              │
│ • id (PK)    │         ┌──────────────┐
│ • buyer_id   │         │QUALITY       │
│ • product    │         │SPECIFICATIONS│
│ • target_price│        │              │
│ • alert_when │         │ • id (PK)    │
│ • is_active  │         │ • buyer_id   │
└──────────────┘         │ • product    │
                         │ • spec_name  │
                         │ • moisture   │
                         │ • purity     │
                         │ • is_default │
                         └──────────────┘

---

## 11. NOTIFICATIONS & AUDIT

┌─────────────────────────────────────────────────────────────┐
│          NOTIFICATIONS & AUDIT SYSTEM                       │
└─────────────────────────────────────────────────────────────┘

┌──────────────┐         ┌──────────────┐         ┌──────────────┐
│NOTIFICATIONS │────────>│PUSH QUEUE    │────────>│PUSH          │
│              │         │              │         │SUBSCRIPTIONS │
│ • id (PK)    │         │ • id (PK)    │         │              │
│ • user_id    │         │ • user_id    │         │ • id (PK)    │
│ • title      │         │ • notif_id   │         │ • user_id    │
│ • message    │         │ • message_id │         │ • endpoint   │
│ • type       │         │ • title      │         │ • p256dh     │
│ • icon       │         │ • body       │         │ • auth       │
│ • link       │         │ • status     │         │ • is_active  │
│ • is_read    │         │ • attempts   │         └──────────────┘
└──────────────┘         └──────────────┘

┌──────────────┐         ┌──────────────┐
│ACTIVITY LOG  │         │ADMIN         │
│              │         │ACTIVITY LOG  │
│ • id (PK)    │         │              │
│ • user_id    │         │ • id (PK)    │
│ • action     │         │ • admin_id   │
│ • description│         │ • action_type│
│ • ip_address │         │ • description│
│ • user_agent │         │ • affected   │
│ • created_at │         │ • ip_address │
└──────────────┘         │ • request    │
                         └──────────────┘

┌──────────────┐
│SYSTEM AUDIT  │
│LOG           │
│              │
│ • id (PK)    │
│ • event_type │
│ • user_id    │
│ • entity_type│
│ • entity_id  │
│ • old_data   │
│ • new_data   │
│ • ip_address │
└──────────────┘

---

## 12. KEY RELATIONSHIPS SUMMARY

### One-to-Many Relationships

1. **Users → Farms** (1:N) - A user can own multiple farms
2. **Farms → Enterprises** (1:N) - A farm can have multiple enterprises
3. **Users → Products** (1:N) - A user can list multiple products
4. **Users → Orders** (1:N as buyer) - A user can place multiple orders
5. **Users → Orders** (1:N as seller) - A user can receive multiple orders
6. **Users → Notifications** (1:N) - A user receives multiple notifications
7. **Chats → Messages** (1:N) - A chat contains multiple messages
8. **Posts → Comments** (1:N) - A post has multiple comments
9. **Groups → Members** (1:N) - A group has multiple members
10. **Region → Districts** (1:N) - Hierarchical location structure

### Many-to-Many Relationships

1. **Users ↔ Users** (M:N via Friendships) - Friendship relationships
2. **Users ↔ Chats** (M:N via Chat Members) - Users can be in multiple chats
3. **Users ↔ Groups** (M:N via Group Members) - Users can join multiple groups
4. **Extension Services ↔ Users** (M:N via Service Participants)
5. **Admin Roles ↔ Permissions** (M:N via Role Permissions)

### One-to-One Relationships

1. **Users → User Profiles** (1:1) - Each user has one profile
2. **Users → User Preferences** (1:1) - Each user has preferences
3. **Users → User Encryption Keys** (1:1) - Each user has encryption keys
4. **Users → Buyer Profiles** (1:1 conditional) - If user is buyer
5. **Users → Extension Officer Profiles** (1:1 conditional) - If extension officer

---

## 13. ENTITY ATTRIBUTES SUMMARY

### Core User Entity

- **Identifiers**: id (PK), phone_number (unique)
- **Authentication**: password_hash, is_verified
- **Profile**: full_name, email, profile_picture
- **Location**: region_id, district_id, subcounty_id, parish_id, village_id
- **Type & Status**: user_type (enum), approval_status, is_active
- **Metadata**: created_at, updated_at, last_login, last_activity

### Location Hierarchy

- Region → District → Subcounty → Parish → Village
- Each level has: id, name, code, parent_id, created_at

### Product Entity

- **Identifiers**: id, seller_id, enterprise_id
- **Details**: name, category, description, quantity, unit
- **Pricing**: price_per_unit
- **Media**: images (JSON)
- **Status**: status (enum), views
- **Timestamps**: created_at, updated_at, expires_at

### Chat & Messaging

- Chat: id, type, name, avatar, created_by
- Message: id, chat_id, sender_id, type, content, media_url
- Encryption: Keys stored per user per chat

### Farm Management

- Farm: id, user_id, name, acres, location (lat/lng)
- Enterprise: id, farm_id, type, size, dates, status
- **Transaction**: id, user_id, enterprise_id, type, amount, date

---

## 14. CARDINALITY NOTATION

Notation Used:
─────  One to One (1:1)
────>  One to Many (1:N)
<────> Many to Many (M:N)
(PK)   Primary Key
(FK)   Foreign Key
(UK)   Unique Key

---

## 15. DATABASE INDEXES STRATEGY

### High-Priority Indexes

- `idx_users_phone` - ON users(phone_number)
- `idx_users_type` - ON users(user_type)
- `idx_products_seller` - ON products(seller_id)
- `idx_products_category_status` - ON products(category, status)
- `idx_orders_buyer_status` - ON orders(buyer_id, status)
- `idx_messages_chat_date` - ON messages(chat_id, created_at)
- `idx_notifications_user_read` - ON notifications(user_id, is_read)
- `idx_market_prices_product_date` - ON market_prices(product_type, price_date)

---
