<?php
/**
 * ============================================================================
 * dashboard/widgets/recent-activity.php
 * Recent Activity Widget - Shows user's recent actions and system events
 * ============================================================================
 */
?>
<?php
$userId = getUserId();
$database = new Database();
$db = $database->getConnection();

// Fetch recent activities
$sql = "SELECT * FROM activity_log 
        WHERE user_id = ? 
        ORDER BY created_at DESC 
        LIMIT 10";
$stmt = $db->prepare($sql);
$stmt->execute([$userId]);
$activities = $stmt->fetchAll();
?>

<div class="card border-0 shadow-sm">
    <div class="card-header bg-white border-0 py-3">
        <h5 class="mb-0 fw-bold">
            <i class="bi bi-clock-history text-info me-2"></i>Recent Activity
        </h5>
    </div>
    <div class="card-body p-0" style="max-height: 400px; overflow-y: auto;">
        <?php if (empty($activities)): ?>
            <div class="text-center py-5 px-3">
                <i class="bi bi-activity text-muted" style="font-size: 3rem;"></i>
                <p class="text-muted small mb-0 mt-2">No recent activity</p>
            </div>
        <?php else: ?>
            <div class="list-group list-group-flush">
                <?php foreach ($activities as $activity): ?>
                <div class="list-group-item">
                    <div class="d-flex align-items-start">
                        <div class="flex-shrink-0 me-3">
                            <?php
                            // Determine icon and color based on action
                            $iconMap = [
                                'login' => ['icon' => 'box-arrow-in-right', 'color' => 'success'],
                                'logout' => ['icon' => 'box-arrow-right', 'color' => 'secondary'],
                                'add_product' => ['icon' => 'plus-circle', 'color' => 'success'],
                                'edit_product' => ['icon' => 'pencil', 'color' => 'primary'],
                                'delete_product' => ['icon' => 'trash', 'color' => 'danger'],
                                'view_product' => ['icon' => 'eye', 'color' => 'info'],
                                'create_order' => ['icon' => 'cart-check', 'color' => 'success'],
                                'send_message' => ['icon' => 'chat-dots', 'color' => 'primary'],
                                'update_farm' => ['icon' => 'tree', 'color' => 'success'],
                                'add_enterprise' => ['icon' => 'plus-square', 'color' => 'success'],
                                'profile_update' => ['icon' => 'person-check', 'color' => 'primary']
                            ];
                            
                            $actionKey = strtolower(str_replace(' ', '_', $activity['action']));
                            $iconInfo = $iconMap[$actionKey] ?? ['icon' => 'circle-fill', 'color' => 'secondary'];
                            ?>
                            <div class="bg-<?php echo $iconInfo['color']; ?> bg-opacity-10 text-<?php echo $iconInfo['color']; ?> rounded-circle p-2">
                                <i class="bi bi-<?php echo $iconInfo['icon']; ?>"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <h6 class="mb-1 small fw-semibold">
                                        <?php echo htmlspecialchars(ucwords(str_replace('_', ' ', $activity['action']))); ?>
                                    </h6>
                                    <?php if (!empty($activity['description'])): ?>
                                        <p class="mb-1 small text-muted">
                                            <?php echo htmlspecialchars($activity['description']); ?>
                                        </p>
                                    <?php endif; ?>
                                    <small class="text-muted">
                                        <i class="bi bi-clock me-1"></i><?php echo timeAgo($activity['created_at']); ?>
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
    <?php if (!empty($activities)): ?>
    <div class="card-footer bg-white border-0 text-center py-2">
        <a href="<?php echo APP_URL; ?>/activity/" class="btn btn-sm btn-link text-decoration-none">
            View All Activity <i class="bi bi-arrow-right ms-1"></i>
        </a>
    </div>
    <?php endif; ?>
</div>