<?php
/**
 * ============================================================================
 * dashboard/widgets/quick-actions.php
 * Quick Actions Widget - Action buttons for common tasks
 * ============================================================================
 */
?>
<?php
$userType = getUserType();

// Define actions based on user type
$actions = [];

if ($userType === 'farmer') {
    $actions = [
        [
            'title' => 'Add Product',
            'icon' => 'bi-plus-circle',
            'color' => 'success',
            'url' => APP_URL . '/marketplace/add-product.php'
        ],
        [
            'title' => 'Market Prices',
            'icon' => 'bi-graph-up',
            'color' => 'primary',
            'url' => APP_URL . '/prices/'
        ],
        [
            'title' => 'AI Assistant',
            'icon' => 'bi-robot',
            'color' => 'info',
            'url' => APP_URL . '/ai-assistant/'
        ],
        [
            'title' => 'My Farm',
            'icon' => 'bi-clipboard-data',
            'color' => 'warning',
            'url' => APP_URL . '/farm/'
        ]
    ];
} elseif ($userType === 'buyer') {
    $actions = [
        [
            'title' => 'Browse Products',
            'icon' => 'bi-shop',
            'color' => 'primary',
            'url' => APP_URL . '/marketplace/'
        ],
        [
            'title' => 'My Orders',
            'icon' => 'bi-cart-check',
            'color' => 'success',
            'url' => APP_URL . '/orders/'
        ],
        [
            'title' => 'Favorites',
            'icon' => 'bi-heart',
            'color' => 'danger',
            'url' => APP_URL . '/favorites/'
        ],
        [
            'title' => 'Chat',
            'icon' => 'bi-chat-dots',
            'color' => 'info',
            'url' => APP_URL . '/chat/'
        ]
    ];
} elseif ($userType === 'extension_officer') {
    $actions = [
        [
            'title' => 'Schedule Service',
            'icon' => 'bi-calendar-plus',
            'color' => 'primary',
            'url' => APP_URL . '/extension/add-service.php'
        ],
        [
            'title' => 'My Services',
            'icon' => 'bi-list-check',
            'color' => 'success',
            'url' => APP_URL . '/extension/services.php'
        ],
        [
            'title' => 'Farmers',
            'icon' => 'bi-people',
            'color' => 'info',
            'url' => APP_URL . '/extension/farmers.php'
        ],
        [
            'title' => 'Resources',
            'icon' => 'bi-book',
            'color' => 'warning',
            'url' => APP_URL . '/learning/'
        ]
    ];
}
?>

<div class="card border-0 shadow-sm">
    <div class="card-header bg-white border-0 py-3">
        <h5 class="mb-0 fw-bold">
            <i class="bi bi-lightning-charge text-warning me-2"></i>Quick Actions
        </h5>
    </div>
    <div class="card-body">
        <div class="row g-3">
            <?php foreach ($actions as $action): ?>
            <div class="col-md-<?php echo 12 / count($actions); ?> col-6">
                <a href="<?php echo $action['url']; ?>" class="quick-action-btn text-center">
                    <i class="bi <?php echo $action['icon']; ?> text-<?php echo $action['color']; ?> fs-2 d-block mb-2"></i>
                    <span class="d-block fw-semibold small"><?php echo $action['title']; ?></span>
                </a>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<style>
.quick-action-btn {
    border-radius: 15px;
    padding: 20px;
    text-decoration: none;
    display: block;
    transition: all 0.3s ease;
    border: 2px solid #e5e7eb;
    background: white;
    color: inherit;
}

.quick-action-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    border-color: var(--primary-color);
}
</style>
