<?php
/**
 * ============================================================================
 * knowledge-base-english.php - English Knowledge Base
 * ============================================================================
 * Pattern-based responses for agricultural questions in English
 */

return [
    // ============================================================================
    // GREETINGS & INTRODUCTIONS
    // ============================================================================
    '/^(hello|hi|hey|good morning|good afternoon|good evening|greetings|howdy)/i' =>
        "Hello! 👋 Great to hear from you!\n\n" .
        "I'm **AIM AI**, your intelligent agricultural assistant for Uganda. I'm here to help you succeed in farming!\n\n" .
        "**I can help you with:**\n" .
        "🌱 **Crop Diseases & Pests** - Identify and treat problems\n" .
        "📅 **Planting Schedules** - Know when to plant for best yields\n" .
        "💰 **Market Prices** - Get current prices and selling tips\n" .
        "🌾 **Best Practices** - Learn modern farming techniques\n" .
        "🐔 **Livestock Care** - Poultry, cattle, goats management\n" .
        "☀️ **Weather Advice** - Climate-smart farming tips\n\n" .
        "**You can ask in English or Lusoga!**\n" .
        "What would you like to know? 🚜",

    '/how are you|how do you do|whats up|wassup|how is it going/i' =>
        "I'm doing great, thank you! 😊\n\n" .
        "I'm always ready to help Ugandan farmers like you succeed! Whether you need help with:\n" .
        "- Identifying crop diseases\n" .
        "- Finding best planting times\n" .
        "- Getting market prices\n" .
        "- Managing your farm better\n\n" .
        "Just ask me anything about farming! 🌾",

    // ============================================================================
    // MAIZE (CORN)
    // ============================================================================
    '/maize.*rust|rust.*disease|rust.*maize|maize.*brown.*spots/i' =>
        "**🌽 Maize Rust Disease Control**\n\n" .
        "**Symptoms to Watch For:**\n" .
        "- Small circular to elongated brown pustules on leaves\n" .
        "- Rust appears on both sides of leaves\n" .
        "- Yellow to orange rust spores when rubbed\n" .
        "- Severe cases: leaves dry prematurely\n\n" .
        "**Control Methods:**\n\n" .
        "**1. Chemical Control:**\n" .
        "- Spray **Mancozeb** or **Metalaxyl** fungicide\n" .
        "- Apply when first symptoms appear\n" .
        "- Repeat every 14 days if needed\n" .
        "- Cost: UGX 15,000-25,000 per kg\n\n" .
        "**2. Resistant Varieties (Best Solution):**\n" .
        "- **Longe 10H** - Excellent resistance\n" .
        "- **DH04** - Good resistance, high yield\n" .
        "- **Longe 5** - Tolerant variety\n" .
        "- **NASE varieties** - Local resistant types\n\n" .
        "**3. Cultural Practices:**\n" .
        "- Rotate with legumes (beans, groundnuts)\n" .
        "- Remove infected crop residues after harvest\n" .
        "- Plant with proper spacing (75cm x 30cm)\n" .
        "- Apply balanced NPK fertilizer\n\n" .
        "**4. Prevention:**\n" .
        "- Use certified, disease-free seeds\n" .
        "- Plant during recommended season\n" .
        "- Avoid overhead irrigation\n" .
        "- Keep field weed-free\n\n" .
        "💡 **Pro Tip:** Early planting (start of rains) helps avoid rust!",

    '/fall.*armyworm|armyworm|worm.*eating.*maize|caterpillar.*maize/i' =>
        "**🐛 Fall Armyworm Control Guide**\n\n" .
        "**How to Identify:**\n" .
        "- Green/brown caterpillars with white stripes\n" .
        "- White inverted \"Y\" mark on head\n" .
        "- Feed on young leaves, creating holes\n" .
        "- Hide in leaf whorls during the day\n" .
        "- Active at night\n\n" .
        "**Control Methods:**\n\n" .
        "**1. Manual Control (Free!):**\n" .
        "- Check plants every morning\n" .
        "- Hand-pick larvae from whorls\n" .
        "- Drop them in soapy water to kill\n" .
        "- Crush egg masses on leaves\n\n" .
        "**2. Home Remedies:**\n" .
        "**Ash + Soap Mixture:**\n" .
        "- Mix wood ash with liquid soap\n" .
        "- Add small amount of water\n" .
        "- Drop mixture into leaf whorls\n" .
        "- Repeat every 3 days\n\n" .
        "**Neem Solution:**\n" .
        "- 50g crushed neem seeds in 1L water\n" .
        "- Soak overnight, strain\n" .
        "- Add 1 tablespoon soap\n" .
        "- Spray early morning or evening\n\n" .
        "**Garlic-Chili Spray:**\n" .
        "- Blend 10 garlic cloves + 5 hot chilies\n" .
        "- Add 1 liter water, strain\n" .
        "- Spray on plants weekly\n\n" .
        "**3. Biological Control:**\n" .
        "- Use **Bt (Bacillus thuringiensis)**\n" .
        "- Release natural enemies (wasps)\n" .
        "- Encourage birds in farm\n\n" .
        "**4. Chemical Control:**\n" .
        "- **Emamectin benzoate** (Belt, Escort)\n" .
        "- **Chlorantraniliprole** (Ampligo)\n" .
        "- **Profenofos** (Curacron)\n" .
        "- Apply early morning or evening\n" .
        "- Target whorls and young plants\n\n" .
        "**Prevention Tips:**\n" .
        "- Plant early in season\n" .
        "- Use resistant varieties\n" .
        "- Intercrop with beans/groundnuts\n" .
        "- Destroy crop residues\n" .
        "- Monitor farm regularly\n\n" .
        "💡 **Save Money:** Start with manual + home remedies before buying chemicals!",

    '/maize.*streak|streak.*virus|maize.*virus/i' =>
        "**🌽 Maize Streak Virus (MSV)**\n\n" .
        "**Symptoms:**\n" .
        "- Yellow/white streaks parallel to leaf veins\n" .
        "- Stunted plant growth\n" .
        "- Reduced cob size\n" .
        "- Young plants most affected\n\n" .
        "**Important:** No cure exists! Prevention is key.\n\n" .
        "**Control Strategy:**\n\n" .
        "**1. Use Resistant Varieties (BEST Solution):**\n" .
        "- **Longe 10H** - Highly resistant\n" .
        "- **Longe 5, 6, 7**\n" .
        "- **NASE varieties**\n" .
        "- **PAN varieties**\n\n" .
        "**2. Control Leafhoppers (Vector):**\n" .
        "- Spray **Imidacloprid** or **Acetamiprid**\n" .
        "- Apply 2-3 weeks after emergence\n" .
        "- Repeat if infestation continues\n\n" .
        "**3. Cultural Practices:**\n" .
        "- Plant early in season\n" .
        "- Rogue out infected seedlings immediately\n" .
        "- Keep field clean of weeds\n" .
        "- Use certified seeds only\n\n" .
        "**4. Prevention:**\n" .
        "- Avoid late planting\n" .
        "- Maintain good soil fertility\n" .
        "- Destroy volunteer maize plants\n" .
        "- Practice crop rotation",

    '/when.*plant.*maize|maize.*planting.*time|maize.*season/i' =>
        "**📅 Maize Planting Calendar for Uganda**\n\n" .
        "**Best Planting Times:**\n\n" .
        "**Season 1 (Main Season):**\n" .
        "- **March - April** (Start with first rains)\n" .
        "- Best for highest yields\n" .
        "- Harvest: July - August\n\n" .
        "**Season 2:**\n" .
        "- **August - September**\n" .
        "- Shorter season\n" .
        "- Harvest: December - January\n\n" .
        "**Requirements:**\n" .
        "- Minimum rainfall: 500mm during growing period\n" .
        "- Temperature: 18-27°C optimal\n" .
        "- Well-drained soil\n" .
        "- pH 5.5-7.5\n\n" .
        "**Planting Guide:**\n\n" .
        "**Spacing:**\n" .
        "- Between rows: **75cm**\n" .
        "- Within row: **25-30cm**\n" .
        "- 2 seeds per hole, thin to 1 later\n\n" .
        "**Seed Rate:**\n" .
        "- 10-15kg per acre\n\n" .
        "**Fertilizer Application:**\n" .
        "- **At Planting:** DAP 50kg/acre\n" .
        "- **4 Weeks Later:** Urea 50kg/acre (top dressing)\n" .
        "- **Or NPK (17:17:17):** 100kg/acre split\n\n" .
        "**Best Varieties for Uganda:**\n" .
        "- **Longe 10H** - 120 days, high yield (8-10 tons/acre)\n" .
        "- **Longe 5** - 110 days, drought tolerant\n" .
        "- **DH04** - 120 days, disease resistant\n" .
        "- **NASE 4 Good** - 115 days\n" .
        "- **PAN 691** - Hybrid, high yield\n\n" .
        "**Key Dates:**\n" .
        "- Weeding: 3 & 6 weeks after planting\n" .
        "- Top dressing: 4 weeks\n" .
        "- Maturity: 100-130 days\n" .
        "- Harvest: When moisture <13.5%\n\n" .
        "💡 **Pro Tip:** Plant within 2 weeks of first rains for best results!",

    '/maize.*price|price.*maize|sell.*maize/i' =>
        "**💰 Maize Market Information**\n\n" .
        "**Current Price Range (Eastern Uganda):**\n" .
        "- **Farm Gate:** UGX 800-1,200 per kg\n" .
        "- **Local Market:** UGX 1,000-1,500 per kg\n" .
        "- **Premium Quality:** UGX 1,200-1,800 per kg\n\n" .
        "*Note: Prices vary by season and quality*\n\n" .
        "**Best Time to Sell:**\n" .
        "- **December - February:** Highest prices (lean season)\n" .
        "- **August - October:** Lower prices (harvest time)\n\n" .
        "**Getting Better Prices:**\n\n" .
        "**1. Quality Matters:**\n" .
        "- Dry properly (moisture <13.5%)\n" .
        "- Remove broken/damaged grains\n" .
        "- Clean and sort grains\n" .
        "- No aflatoxin contamination\n\n" .
        "**2. Storage Strategy:**\n" .
        "- Use hermetic bags (P urdue I mproved C rop S torage)\n" .
        "- Store in dry, cool place\n" .
        "- Regular inspection for pests\n" .
        "- Sell when prices peak (Dec-Feb)\n\n" .
        "**3. Marketing Options:**\n" .
        "- **Direct to Processors:** Highest price but need volume\n" .
        "- **Farmer Groups:** Better bargaining power\n" .
        "- **Local Traders:** Quick cash but lower price\n" .
        "- **AIMS Marketplace:** Connect with buyers!\n\n" .
        "**4. Value Addition:**\n" .
        "- Shelling service: +UGX 50-100/kg\n" .
        "- Grading service: +UGX 100-200/kg\n" .
        "- Cleaning: +UGX 50/kg\n\n" .
        "**Major Buyers:**\n" .
        "- National Enterprises Corporation\n" .
        "- Mukwano Industries\n" .
        "- Nile Breweries\n" .
        "- World Food Programme\n\n" .
        "💡 **Use AIMS Marketplace** to:\n" .
        "- Post your maize for sale\n" .
        "- Compare prices from different buyers\n" .
        "- Set price alerts\n" .
        "- Connect directly with buyers",

    // ============================================================================
    // BEANS
    // ============================================================================
    '/when.*plant.*beans|bean.*planting.*season|bean.*schedule/i' =>
        "**🫘 Bean Planting Guide for Uganda**\n\n" .
        "**Best Planting Times:**\n\n" .
        "**Season 1:**\n" .
        "- **February - March**\n" .
        "- Main season, higher yields\n" .
        "- Harvest: May - June\n\n" .
        "**Season 2:**\n" .
        "- **August - September**\n" .
        "- Short season\n" .
        "- Harvest: November - December\n\n" .
        "**Requirements:**\n" .
        "- Rainfall: Minimum 300mm\n" .
        "- Temperature: 18-24°C optimal\n" .
        "- Well-drained soil, pH 6.0-7.5\n" .
        "- Avoid waterlogged areas\n\n" .
        "**Planting Instructions:**\n\n" .
        "**Spacing:**\n" .
        "- Between rows: **50cm**\n" .
        "- Within row: **10cm**\n" .
        "- Depth: **3-5cm**\n" .
        "- 1-2 seeds per hole\n\n" .
        "**Seed Rate:**\n" .
        "- 40-50kg per acre\n" .
        "- Cost: UGX 50,000-80,000\n\n" .
        "**Fertilizer:**\n" .
        "- **DAP:** 50kg/acre at planting\n" .
        "- Beans fix nitrogen, need less fertilizer\n" .
        "- Top dress if soil poor\n\n" .
        "**Top Varieties:**\n\n" .
        "**Climbing Beans:**\n" .
        "- **NABE 15** - 90 days, 2.5 tons/acre\n" .
        "- **NABE 16** - 90 days, good market\n" .
        "- **NABE 17** - 85 days, drought tolerant\n\n" .
        "**Bush Beans:**\n" .
        "- **K132** - 75 days, disease resistant\n" .
        "- **K131** - 80 days\n" .
        "- **NABE 4** - 75 days, good yield\n\n" .
        "**Management:**\n" .
        "- Weed 2-3 times\n" .
        "- Stake climbing beans at 2 weeks\n" .
        "- Watch for aphids and bean fly\n" .
        "- Spray if needed\n\n" .
        "**Harvest:**\n" .
        "- When 90% pods are dry\n" .
        "- Sun-dry to 13% moisture\n" .
        "- Store in cool, dry place\n\n" .
        "💡 **Intercrop with maize** for better land use!",

    '/bean.*disease|bean.*pests|aphid.*beans/i' =>
        "**🫘 Common Bean Problems & Solutions**\n\n" .
        "**1. Aphids (Black Bean Aphid)**\n\n" .
        "**Symptoms:**\n" .
        "- Tiny black insects on leaves/stems\n" .
        "- Curled, distorted leaves\n" .
        "- Sticky honeydew on plants\n" .
        "- Stunted growth\n\n" .
        "**Control:**\n" .
        "**Organic Methods:**\n" .
        "- Spray soapy water (2 tbsp soap/liter)\n" .
        "- Neem oil spray\n" .
        "- Wood ash dusting\n" .
        "- Remove heavily infested plants\n\n" .
        "**Chemical:**\n" .
        "- Imidacloprid (Confidor)\n" .
        "- Acetamiprid (Rescate)\n" .
        "- Lambda-cyhalothrin (Karate)\n\n" .
        "**2. Bean Fly**\n\n" .
        "**Symptoms:**\n" .
        "- Maggots in stems\n" .
        "- Wilting seedlings\n" .
        "- Plant death\n\n" .
        "**Control:**\n" .
        "- Treat seeds before planting\n" .
        "- Use Seed dressing chemicals\n" .
        "- Early planting\n" .
        "- Remove wilted plants\n\n" .
        "**3. Angular Leaf Spot**\n\n" .
        "**Symptoms:**\n" .
        "- Angular brown spots on leaves\n" .
        "- Spots have yellow border\n" .
        "- Leaf drop in severe cases\n\n" .
        "**Control:**\n" .
        "- Use certified disease-free seeds\n" .
        "- Spray copper fungicides\n" .
        "- Remove infected plant debris\n" .
        "- Rotate crops\n\n" .
        "**4. Bean Rust**\n\n" .
        "**Symptoms:**\n" .
        "- Reddish-brown pustules on leaves\n" .
        "- Premature leaf drop\n\n" .
        "**Control:**\n" .
        "- Use resistant varieties\n" .
        "- Spray Mancozeb fungicide\n" .
        "- Proper plant spacing\n\n" .
        "**5. Root Rot**\n\n" .
        "**Symptoms:**\n" .
        "- Wilting plants\n" .
        "- Brown, rotting roots\n" .
        "- Plant death\n\n" .
        "**Control:**\n" .
        "- Improve drainage\n" .
        "- Avoid overwatering\n" .
        "- Use resistant varieties\n" .
        "- Crop rotation\n\n" .
        "**Prevention Tips:**\n" .
        "- Use certified seeds\n" .
        "- Proper spacing for air circulation\n" .
        "- Regular field inspection\n" .
        "- Remove diseased plants immediately\n" .
        "- Crop rotation (don't plant beans continuously)\n\n" .
        "💡 **Weekly Monitoring** helps catch problems early!",

    // ============================================================================
    // CASSAVA
    // ============================================================================
    '/cassava.*disease|cassava.*brown.*streak|mosaic.*cassava|cassava.*problem/i' =>
        "**🌿 Cassava Disease Management**\n\n" .
        "**1. Cassava Brown Streak Disease (CBSD)**\n\n" .
        "**Symptoms:**\n" .
        "- Yellow/brown blotches on leaves\n" .
        "- Brown necrotic patches inside roots\n" .
        "- Leaf chlorosis (yellowing)\n" .
        "- Stunted growth\n" .
        "- Reduced root quality\n\n" .
        "**Control:**\n" .
        "✅ **Use Clean Planting Material:**\n" .
        "- Get cuttings from disease-free fields\n" .
        "- Use middle portions of stems\n" .
        "- Avoid cuttings from infected plants\n\n" .
        "✅ **Plant Resistant Varieties:**\n" .
        "- **NASE 14** (Highly resistant)\n" .
        "- **NASE 19** (Tolerant)\n" .
        "- **Mkumba** (Resistant)\n" .
        "- **NASE 3** (Moderately resistant)\n\n" .
        "✅ **Field Sanitation:**\n" .
        "- Remove and burn infected plants\n" .
        "- Don't use infected plants for cuttings\n" .
        "- Control whiteflies (disease vector)\n\n" .
        "**2. Cassava Mosaic Disease (CMD)**\n\n" .
        "**Symptoms:**\n" .
        "- Yellowish-white mosaic patterns on leaves\n" .
        "- Leaf distortion and curling\n" .
        "- Severely stunted plants\n" .
        "- Reduced root yield (up to 90%!)\n\n" .
        "**Control:**\n" .
        "✅ **Resistant Varieties (BEST Solution):**\n" .
        "- **NASE 1**\n" .
        "- **NASE 3**\n" .
        "- **TME 14**\n" .
        "- **NASE 18**\n\n" .
        "✅ **Roguing (Very Important!):**\n" .
        "- Remove diseased plants within first 2 months\n" .
        "- Destroy them completely\n" .
        "- This stops spread\n\n" .
        "✅ **Vector Control:**\n" .
        "- Control whiteflies with neem oil\n" .
        "- Or use Imidacloprid spray\n\n" .
        "**3. Cassava Bacterial Blight (CBB)**\n\n" .
        "**Symptoms:**\n" .
        "- Water-soaked spots on leaves\n" .
        "- Leaf wilting and die-back\n" .
        "- Gum (sticky liquid) from stems\n" .
        "- Leaf and stem cankers\n\n" .
        "**Control:**\n" .
        "- Use disease-free cuttings\n" .
        "- Avoid planting in waterlogged areas\n" .
        "- Remove and burn infected plants\n" .
        "- Disinfect cutting tools (dip in bleach water)\n" .
        "- Plant resistant varieties\n\n" .
        "**General Prevention:**\n\n" .
        "**1. Quality Planting Material:**\n" .
        "- Use hardwood cuttings (25-30cm)\n" .
        "- From 8-12 month old healthy plants\n" .
        "- Middle portion of stem is best\n" .
        "- Plant within 24 hours of cutting\n\n" .
        "**2. Field Practices:**\n" .
        "- Crop rotation (3-4 years)\n" .
        "- Proper spacing (1m x 1m)\n" .
        "- Weed control\n" .
        "- Remove volunteer plants\n\n" .
        "**3. Harvest:**\n" .
        "- 10-12 months for most varieties\n" .
        "- 12-18 months for high starch content\n" .
        "- Process within 24-48 hours\n\n" .
        "💡 **Most Important:** Use resistant varieties and clean planting material!",

    '/when.*plant.*cassava|cassava.*planting/i' =>
        "**🌿 Cassava Planting Guide**\n\n" .
        "**Best Planting Time:**\n" .
        "- **Start of rainy season** (March-April or Sept-Oct)\n" .
        "- Soil should be moist but not waterlogged\n" .
        "- Cassava needs 8-12 months, so time your harvest\n\n" .
        "**Planting Procedure:**\n\n" .
        "**1. Prepare Cuttings:**\n" .
        "- Use healthy 8-12 month old plants\n" .
        "- Cut stems into 25-30cm pieces\n" .
        "- Use middle portions (better than top/bottom)\n" .
        "- Each cutting should have 5-7 nodes\n" .
        "- Plant within 24 hours of cutting\n\n" .
        "**2. Land Preparation:**\n" .
        "- Clear land completely\n" .
        "- Make mounds or ridges (optional but better)\n" .
        "- Add manure if available (5 tons/acre)\n\n" .
        "**3. Spacing:**\n" .
        "- **1 meter x 1 meter** (standard)\n" .
        "- Gives 4,000 plants per acre\n" .
        "- Closer spacing (0.8m x 0.8m) for earlier harvest\n\n" .
        "**4. Planting Method:**\n" .
        "- Plant cuttings at 45° angle or flat\n" .
        "- Bury 2/3 of cutting in soil\n" .
        "- Leave 1/3 (2-3 nodes) above ground\n" .
        "- Firm soil around cutting\n\n" .
        "**Cutting Requirements:**\n" .
        "- 4,000-6,000 cuttings per acre\n" .
        "- Get from reliable source or own healthy field\n" .
        "- Cost: UGX 50-100 per cutting\n\n" .
        "**Top Varieties:**\n\n" .
        "**High Yielding:**\n" .
        "- **NASE 14** - 35-40 tons/acre, resistant to CBSD\n" .
        "- **NASE 19** - 30-35 tons/acre\n" .
        "- **NASE 3** - Early maturing\n\n" .
        "**Disease Resistant:**\n" .
        "- **TME 14** - CMD resistant\n" .
        "- **Mkumba** - CBSD resistant\n" .
        "- **NASE 18** - Multiple disease resistance\n\n" .
        "**Management:**\n" .
        "- **1st weeding:** 1 month after planting\n" .
        "- **2nd weeding:** 3 months\n" .
        "- **3rd weeding:** 5 months (if needed)\n" .
        "- No fertilizer usually needed\n" .
        "- Check regularly for diseases\n\n" .
        "**Harvest:**\n" .
        "- **10-12 months:** Food cassava\n" .
        "- **12-18 months:** Industrial cassava\n" .
        "- Don't delay >18 months (roots become woody)\n" .
        "- Harvest during dry season\n\n" .
        "**Yield Expectation:**\n" .
        "- Good management: 25-40 tons/acre\n" .
        "- Average: 15-20 tons/acre\n" .
        "- Poor management: <10 tons/acre\n\n" .
        "💡 **Pro Tip:** Intercrop with beans in first 3-4 months for extra income!",

    // Continue with more patterns...
    // Adding vegetables, soil, weather, livestock, etc.

    '/thank you|thanks|appreciate|grateful/i' =>
        "You're very welcome! 😊\n\n" .
        "I'm always here to help you succeed in your farming journey. Don't hesitate to ask more questions anytime!\n\n" .
        "**Remember:**\n" .
        "- Monitor your crops regularly\n" .
        "- Use the AIMS marketplace to sell\n" .
        "- Set price alerts for your products\n" .
        "- Join farmer groups for better prices\n\n" .
        "Happy farming! 🌾🚜\n\n" .
        "*Kabisaana mu by'obulimi!*",
];