# AIMS Platform - Use Case Diagrams

## Agricultural Information and Market Linkage System

### Student: Musumba Jonathan (21/BCS/010/UMC)

### Institution: Metropolitan International University

---

## 1. SYSTEM-LEVEL USE CASE OVERVIEW

┌─────────────────────────────────────────────────────────────────────┐
│                    AIMS PLATFORM - HIGH LEVEL                       │
│                     Use Case Overview                               │
└─────────────────────────────────────────────────────────────────────┘

                              ┌────────────┐
                              │   SYSTEM   │
                              │            │
                              └─────┬──────┘
                                    │
        ┌───────────────┬───────────┼───────────┬─────────────┐
        │               │           │           │             │
        ▼               ▼           ▼           ▼             ▼
   ┌─────────┐    ┌─────────┐ ┌─────────┐ ┌─────────┐  ┌─────────┐
   │ Farmer  │    │  Buyer  │ │Extension│ │  Admin  │  │   AI    │
   │         │    │         │ │ Officer │ │         │  │Assistant│
   └─────────┘    └─────────┘ └─────────┘ └─────────┘  └─────────┘
        │               │           │           │             │
        │               │           │           │             │
   Farm Mgmt      Procurement  Extension   System Mgmt   Knowledge
   Marketplace    Sourcing     Services    Analytics     Support
   Collaboration  Contracts    Training    Approval      Translation

---

## 2. FARMER USE CASES

┌─────────────────────────────────────────────────────────────────────┐
│                      FARMER ACTOR                                   │
└─────────────────────────────────────────────────────────────────────┘

┌──────────┐
│  Farmer  │
└────┬─────┘
     │
     ├──> (Register Account)
     │         └──> «include» (Verify Phone via OTP)
     │         └──> «extend» (Complete Profile)
     │
     ├──> (Login)
     │         └──> «include» (Authenticate)
     │         └──> «extend» (Two-Factor Auth)
     │
     ├──────────────── FARM MANAGEMENT ──────────────────
     │
     ├──> (Manage Farm)
     │         ├──> (Add Farm Details)
     │         ├──> (Update Farm Info)
     │         └──> (Set Farm Location)
     │
     ├──> (Manage Enterprises)
     │         ├──> (Add Enterprise)
     │         │         └──> «include» (Select Crop Type)
     │         │         └──> «include» (Set Planting Date)
     │         ├──> (Track Growth Stages)
     │         ├──> (Update Enterprise Status)
     │         └──> (Record Harvest)
     │
     ├──> (Track Finances)
     │         ├──> (Record Income)
     │         ├──> (Record Expenses)
     │         ├──> (View Financial Reports)
     │         │         └──> «include» (Generate Charts)
     │         └──> (Export Financial Data)
     │
     ├──> (Set Farming Reminders)
     │         ├──> (Create Custom Reminder)
     │         ├──> (Schedule Activity)
     │         ├──> (Enable Notifications)
     │         └──> (Mark as Complete)
     │
     ├──────────────── MARKETPLACE ──────────────────
     │
     ├──> (List Products for Sale)
     │         ├──> (Create Product Listing)
     │         │         └──> «include» (Upload Photos)
     │         │         └──> «include» (Set Price)
     │         │         └──> «include» (Specify Quantity)
     │         ├──> (Edit Product)
     │         ├──> (Mark as Sold)
     │         └──> (Delete Product)
     │
     ├──> (Browse Products)
     │         ├──> (Search Products)
     │         ├──> (Filter by Category)
     │         ├──> (Filter by Location)
     │         └──> (Filter by Price Range)
     │
     ├──> (Manage Orders)
     │         ├──> (View Order Details)
     │         ├──> (Accept Order)
     │         ├──> (Reject Order)
     │         └──> (Update Order Status)
     │
     ├──> (Respond to Inquiries)
     │         └──> «include» (Send Message)
     │
     ├──────────────── PRICE INTELLIGENCE ──────────────────
     │
     ├──> (View Market Prices)
     │         ├──> (Compare Prices)
     │         │         └──> «include» (Select Markets)
     │         │         └──> «include» (View Price Trends)
     │         ├──> (View Historical Data)
     │         └──> (See Price Predictions)
     │
     ├──> (Set Price Alerts)
     │         ├──> (Create Alert)
     │         ├──> (Manage Alerts)
     │         └──> (Receive Notifications)
     │                 └──> «include» (SMS/Push)
     │
     ├──> (Report Market Prices)
     │         └──> «include» (Upload Proof)
     │
     ├──────────────── LEARNING & AI ──────────────────
     │
     ├──> (Access Agricultural Tips)
     │         ├──> (Browse by Category)
     │         ├──> (Search Tips)
     │         └──> (Bookmark Favorites)
     │
     ├──> (Learn Best Practices)
     │         ├──> (Watch Videos)
     │         ├──> (Read Articles)
     │         └──> (Track Progress)
     │
     ├──> (Get AI Assistance)
     │         ├──> (Ask Question)
     │         │         └──> «include» (Select Language)
     │         ├──> (Get Crop Advice)
     │         ├──> (Diagnose Disease)
     │         │         └──> «extend» (Upload Photo)
     │         └──> (Get Weather Info)
     │
     ├──> (Report Crop Disease)
     │         └──> «include» (Upload Photos)
     │         └──> «include» (Describe Symptoms)
     │
     ├──────────────── SOCIAL & COMMUNITY ──────────────────
     │
     ├──> (Connect with Farmers)
     │         ├──> (Send Friend Request)
     │         ├──> (Accept/Reject Request)
     │         └──> (View Friend Profile)
     │
     ├──> (Chat)
     │         ├──> (One-on-One Chat)
     │         │         └──> «include» (Send Message)
     │         │         └──> «extend» (Share Media)
     │         ├──> (Group Chat)
     │         │         └──> «include» (Create Group)
     │         │         └──> «include» (Add Members)
     │         └──> (View Chat History)
     │
     ├──> (Join Community Groups)
     │         ├──> (Browse Groups)
     │         ├──> (Request to Join)
     │         └──> (Leave Group)
     │
     ├──> (Create Posts)
     │         ├──> (Write Post)
     │         ├──> (Share Photos/Videos)
     │         ├──> (Set Visibility)
     │         └──> «extend» (Tag Friends)
     │
     ├──> (Engage with Content)
     │         ├──> (Like Post)
     │         ├──> (Comment)
     │         └──> (Share)
     │
     └──> (Manage Profile)
               ├──> (Update Personal Info)
               ├──> (Upload Profile Photo)
               ├──> (Manage Privacy Settings)
               └──> (Change Password)

---

## 3. BUYER USE CASES

┌─────────────────────────────────────────────────────────────────────┐
│                       BUYER ACTOR                                   │
└─────────────────────────────────────────────────────────────────────┘

┌──────────┐
│  Buyer   │
└────┬─────┘
     │
     ├──> (Register as Buyer)
     │         └──> «include» (Provide Business Details)
     │         └──> «include» (Upload Documents)
     │         └──> «extend» (Wait for Approval)
     │
     ├──────────────── PROCUREMENT ──────────────────
     │
     ├──> (Search for Products)
     │         ├──> (Filter by Quality)
     │         ├──> (Filter by Quantity)
     │         ├──> (Filter by Region)
     │         └──> (Sort by Price)
     │
     ├──> (Place Order)
     │         ├──> (Select Product)
     │         ├──> (Specify Quantity)
     │         ├──> (Add Delivery Address)
     │         └──> «include» (Confirm Order)
     │
     ├──> (Track Orders)
     │         ├──> (View Order Status)
     │         ├──> (Contact Seller)
     │         └──> (Cancel Order)
     │                 └──> «precondition» (Before Confirmation)
     │
     ├──> (Make Inquiry)
     │         ├──> (Ask about Product)
     │         ├──> (Request Custom Quote)
     │         └──> (Negotiate Price)
     │
     ├──────────────── BULK PURCHASING ──────────────────
     │
     ├──> (Create Bulk Order Request)
     │         ├──> (Specify Requirements)
     │         ├──> (Set Budget)
     │         ├──> (Set Deadline)
     │         └──> (Define Quality Specs)
     │
     ├──> (Review Bids)
     │         ├──> (Compare Offers)
     │         ├──> (Check Farmer Ratings)
     │         ├──> (Accept Bid)
     │         └──> (Reject Bid)
     │
     ├──────────────── CONTRACT FARMING ──────────────────
     │
     ├──> (Initiate Contract)
     │         ├──> (Define Terms)
     │         ├──> (Set Quality Standards)
     │         ├──> (Specify Payment Terms)
     │         └──> «include» (Generate Contract)
     │
     ├──> (Monitor Contract)
     │         ├──> (Track Deliveries)
     │         ├──> (Verify Quality)
     │         ├──> (Process Payments)
     │         └──> (Report Issues)
     │
     ├──────────────── SUPPLIER MANAGEMENT ──────────────────
     │
     ├──> (Rate Suppliers)
     │         ├──> (Rate Quality)
     │         ├──> (Rate Delivery)
     │         ├──> (Rate Communication)
     │         └──> (Write Review)
     │
     ├──> (Manage Watchlist)
     │         ├──> (Add Product to Watch)
     │         ├──> (Set Price Alerts)
     │         └──> (Remove from Watch)
     │
     ├──> (Set Preferences)
     │         ├──> (Preferred Categories)
     │         ├──> (Preferred Regions)
     │         ├──> (Quality Requirements)
     │         └──> (Notification Settings)
     │
     ├──────────────── PAYMENTS ──────────────────
     │
     ├──> (Manage Payment Methods)
     │         ├──> (Add Payment Method)
     │         ├──> (Set Default Method)
     │         └──> (Remove Method)
     │
     └──> (View Purchase History)
               ├──> (Filter by Date)
               ├──> (Filter by Supplier)
               ├──> (Export Reports)
               └──> (Download Receipts)

---

## 4. EXTENSION OFFICER USE CASES

┌─────────────────────────────────────────────────────────────────────┐
│                  EXTENSION OFFICER ACTOR                            │
└─────────────────────────────────────────────────────────────────────┘

┌──────────────────┐
│Extension Officer │
└────────┬─────────┘
         │
         ├──> (Register as Extension Officer)
         │         └──> «include» (Provide Credentials)
         │         └──> «include» (Upload Certificates)
         │         └──> «extend» (Wait for Verification)
         │
         ├──────────────── SERVICE DELIVERY ──────────────────
         │
         ├──> (Schedule Services)
         │         ├──> (Plan Farm Visit)
         │         │         └──> «include» (Set Date/Time)
         │         │         └──> «include» (Select Location)
         │         ├──> (Organize Training)
         │         │         └──> «include» (Set Max Participants)
         │         │         └──> «include» (Prepare Materials)
         │         ├──> (Schedule Consultation)
         │         └──> (Plan Demonstration)
         │
         ├──> (Manage Service Attendance)
         │         ├──> (View Registrations)
         │         ├──> (Mark Attendance)
         │         └──> (Collect Feedback)
         │
         ├──> (Conduct Service)
         │         ├──> (Deliver Training)
         │         ├──> (Provide Consultation)
         │         ├──> (Perform Farm Visit)
         │         └──> (Document Findings)
         │
         ├──────────────── FARMER SUPPORT ──────────────────
         │
         ├──> (Respond to Queries)
         │         ├──> (Answer Questions)
         │         ├──> (Provide Advice)
         │         └──> (Share Resources)
         │
         ├──> (Verify Disease Reports)
         │         ├──> (Review Submission)
         │         ├──> (Confirm Disease)
         │         └──> (Recommend Treatment)
         │
         ├──> (Monitor Farm Progress)
         │         ├──> (Track Farmers)
         │         ├──> (Record Observations)
         │         └──> (Provide Guidance)
         │
         ├──────────────── CONTENT CREATION ──────────────────
         │
         ├──> (Create Agricultural Tips)
         │         ├──> (Write Content)
         │         ├──> (Add Media)
         │         ├──> (Select Category)
         │         └──> «include» (Publish)
         │
         ├──> (Upload Resources)
         │         ├──> (Add Documents)
         │         ├──> (Add Videos)
         │         ├──> (Add Presentations)
         │         └──> (Set Target Audience)
         │
         ├──> (Manage Knowledge Base)
         │         ├──> (Update Crop Guides)
         │         ├──> (Document Diseases)
         │         └──> (Add Best Practices)
         │
         ├──────────────── REPORTING ──────────────────
         │
         ├──> (Submit Activity Reports)
         │         ├──> (Daily Report)
         │         ├──> (Weekly Report)
         │         ├──> (Monthly Report)
         │         └──> (Special Report)
         │                 └──> «include» (Upload Evidence)
         │
         ├──> (Log Activities)
         │         ├──> (Record Service Delivery)
         │         ├──> (Record Farmers Reached)
         │         ├──> (Document Issues)
         │         └──> (Note Solutions)
         │
         ├──> (View Performance Metrics)
         │         ├──> (Services Completed)
         │         ├──> (Farmers Assisted)
         │         ├──> (Average Rating)
         │         └──> (Impact Statistics)
         │
         ├──────────────── COLLABORATION ──────────────────
         │
         ├──> (Communicate with Supervisor)
         │         ├──> (Send Updates)
         │         ├──> (Request Support)
         │         └──> (Submit for Review)
         │
         ├──> (Coordinate with Peers)
         │         ├──> (Share Knowledge)
         │         ├──> (Plan Joint Activities)
         │         └──> (Discuss Challenges)
         │
         └──> (Manage Assignment)
                   ├──> (View Assigned Area)
                   ├──> (Update Coverage)
                   └──> (Request Reassignment)

---

## 5. SYSTEM ADMINISTRATOR USE CASES

┌─────────────────────────────────────────────────────────────────────┐
│                 SYSTEM ADMINISTRATOR ACTOR                          │
└─────────────────────────────────────────────────────────────────────┘

┌──────────────┐
│    Admin     │
└──────┬───────┘
       │
       ├──────────────── USER MANAGEMENT ──────────────────
       │
       ├──> (Manage User Accounts)
       │         ├──> (View All Users)
       │         │         └──> «include» (Filter by Type)
       │         │         └──> «include» (Search Users)
       │         ├──> (Activate Account)
       │         ├──> (Deactivate Account)
       │         ├──> (Delete Account)
       │         └──> (Reset Password)
       │
       ├──> (Approve Registrations)
       │         ├──> (Review Buyer Application)
       │         │         └──> «include» (Verify Documents)
       │         ├──> (Review Extension Officer)
       │         │         └──> «include» (Check Credentials)
       │         ├──> (Approve Registration)
       │         └──> (Reject Registration)
       │                 └──> «include» (Provide Reason)
       │
       ├──> (Manage Roles & Permissions)
       │         ├──> (Create Admin Role)
       │         ├──> (Assign Permissions)
       │         ├──> (Modify Role)
       │         └──> (Delete Role)
       │
       ├──────────────── CONTENT MODERATION ──────────────────
       │
       ├──> (Moderate Products)
       │         ├──> (Review Listings)
       │         ├──> (Remove Inappropriate)
       │         └──> (Feature Products)
       │
       ├──> (Moderate Posts)
       │         ├──> (Review Reports)
       │         ├──> (Remove Content)
       │         └──> (Warn User)
       │
       ├──> (Handle Reports)
       │         ├──> (Review Report)
       │         ├──> (Investigate Issue)
       │         ├──> (Take Action)
       │         └──> (Close Report)
       │
       ├──────────────── PRICE MANAGEMENT ──────────────────
       │
       ├──> (Manage Market Prices)
       │         ├──> (Add Price Data)
       │         ├──> (Update Prices)
       │         ├──> (Import Price Data)
       │         │         └──> «include» (Upload CSV)
       │         └──> (Export Price Data)
       │
       ├──> (Verify Price Reports)
       │         ├──> (Review User Reports)
       │         ├──> (Approve Report)
       │         └──> (Reject Report)
       │
       ├──> (Manage Price Sources)
       │         ├──> (Add Source)
       │         ├──> (Configure API)
       │         └──> (Set Reliability Score)
       │
       ├──────────────── EXTENSION MANAGEMENT ──────────────────
       │
       ├──> (Manage Extension Workers)
       │         ├──> (Create Assignment)
       │         │         └──> «include» (Assign Role)
       │         │         └──> «include» (Set Coverage Area)
       │         ├──> (Assign Supervisor)
       │         ├──> (Update Assignment)
       │         └──> (End Assignment)
       │
       ├──> (Review Extension Reports)
       │         ├──> (View Reports)
       │         ├──> (Approve Report)
       │         ├──> (Request Revision)
       │         └──> (Add Comments)
       │
       ├──> (Monitor Performance)
       │         ├──> (View Statistics)
       │         ├──> (Generate Reports)
       │         └──> (Identify Issues)
       │
       ├──────────────── SYSTEM CONFIGURATION ──────────────────
       │
       ├──> (Configure System Settings)
       │         ├──> (Update Parameters)
       │         ├──> (Set Limits)
       │         ├──> (Configure Notifications)
       │         └──> (Manage Features)
       │
       ├──> (Manage Locations)
       │         ├──> (Add Region/District)
       │         ├──> (Update Hierarchy)
       │         └──> (Remove Location)
       │
       ├──> (Configure AI Settings)
       │         ├──> (Manage Patterns)
       │         ├──> (Update Knowledge Base)
       │         └──> (Set AI Parameters)
       │
       ├──────────────── ANALYTICS & REPORTING ──────────────────
       │
       ├──> (View Dashboard)
       │         ├──> (User Statistics)
       │         ├──> (Transaction Metrics)
       │         ├──> (System Health)
       │         └──> (Activity Trends)
       │
       ├──> (Generate Reports)
       │         ├──> (User Reports)
       │         ├──> (Financial Reports)
       │         ├──> (Activity Reports)
       │         └──> (Custom Reports)
       │                 └──> «include» (Select Parameters)
       │
       ├──> (View Audit Logs)
       │         ├──> (System Audit)
       │         ├──> (Admin Activities)
       │         ├──> (User Activities)
       │         └──> (Security Events)
       │
       └──────────────── SYSTEM MAINTENANCE ──────────────────
                 │
                 ├──> (Backup Database)
                 │         └──> «scheduled» (Daily/Weekly)
                 │
                 ├──> (Monitor System Health)
                 │         ├──> (Check Performance)
                 │         ├──> (View Error Logs)
                 │         └──> (Receive Alerts)
                 │
                 └──> (Manage Notifications)
                           ├──> (Send Announcements)
                           ├──> (Broadcast Messages)
                           └──> (Configure Templates)

## 6. AI ASSISTANT USE CASES

┌─────────────────────────────────────────────────────────────────────┐
│                    AI ASSISTANT ACTOR                               │
└─────────────────────────────────────────────────────────────────────┘

┌──────────────┐
│AI Assistant  │
└──────┬───────┘
       │
       ├──────────────── CONVERSATIONAL SUPPORT ──────────────────
       │
       ├──> (Answer Questions)
       │         ├──> «include» (Understand Intent)
       │         ├──> «include» (Search Knowledge Base)
       │         ├──> «include» (Generate Response)
       │         └──> «extend» (Translate to Local Language)
       │
       ├──> (Provide Farming Advice)
       │         ├──> (Crop Recommendations)
       │         ├──> (Planting Calendar)
       │         ├──> (Fertilizer Guidance)
       │         └──> (Pest Control Tips)
       │
       ├──> (Disease Diagnosis)
       │         ├──> «include» (Analyze Symptoms)
       │         ├──> «include» (Image Recognition)
       │         ├──> (Suggest Treatment)
       │         └──> (Recommend Prevention)
       │
       ├──────────────── INFORMATION RETRIEVAL ──────────────────
       │
       ├──> (Fetch Market Prices)
       │         ├──> (Current Prices)
       │         ├──> (Price Trends)
       │         └──> (Price Forecasts)
       │
       ├──> (Provide Weather Info)
       │         ├──> (Current Weather)
       │         ├──> (Forecast)
       │         └──> (Weather Alerts)
       │
       ├──> (Search Products)
       │         ├──> «include» (Parse Query)
       │         ├──> (Find Matches)
       │         └──> (Return Results)
       │
       ├──────────────── LEARNING & ADAPTATION ──────────────────
       │
       ├──> (Learn from Interactions)
       │         ├──> (Capture Feedback)
       │         ├──> (Identify Patterns)
       │         └──> (Update Knowledge)
       │
       ├──> (Improve Responses)
       │         ├──> (Analyze Success Rate)
       │         ├──> (Refine Answers)
       │         └──> (Add New Patterns)
       │
       ├──> (Context Management)
       │         ├──> (Track Session)
       │         ├──> (Maintain History)
       │         └──> (Personalize Responses)
       │
       └──────────────── PROACTIVE ASSISTANCE ──────────────────
                 │
                 ├──> (Send Reminders)
                 │         └──> «triggered» (Based on Schedule)
                 │
                 ├──> (Alert on Prices)
                 │         └──> «triggered» (Price Threshold)
                 │
                 └──> (Suggest Actions)
                           └──> «based on» (User Context)

## 7. CROSS-FUNCTIONAL USE CASES

┌─────────────────────────────────────────────────────────────────────┐
│              SHARED/CROSS-FUNCTIONAL USE CASES                      │
└─────────────────────────────────────────────────────────────────────┘

All Authenticated Users:
│
├──> (Receive Notifications)
│         ├──> (Push Notifications)
│         ├──> (SMS Alerts)
│         ├──> (Email Notifications)
│         └──> (In-App Notifications)
│
├──> (Search Platform)
│         ├──> (Search Products)
│         ├──> (Search Users)
│         ├──> (Search Content)
│         └──> (Search Groups)
│
├──> (View Profile)
│         ├──> (Own Profile)
│         └──> (Other User Profile)
│                 └──> «based on» (Privacy Settings)
│
├──> (Update Profile)
│         ├──> (Personal Info)
│         ├──> (Photos)
│         ├──> (Bio)
│         └──> (Settings)
│
├──> (Communicate)
│         ├──> (Send Message)
│         ├──> (Chat)
│         └──> (Comment)
│
└──> (Manage Privacy)
          ├──> (Update Preferences)
          ├──> (Block User)
          └──> (Report Abuse)

---

## 8. USE CASE RELATIONSHIPS

### Include Relationships (mandatory)

- Login «include» Authenticate
- Register «include» Verify Phone
- Create Product «include» Upload Photos
- Place Order «include» Confirm Order
- Schedule Service «include» Set Date/Time

### Extend Relationships (optional)

- Register «extend» Complete Profile
- Chat «extend» Share Media
- Disease Diagnosis «extend» Upload Photo
- Answer Question «extend» Translate

### Generalization

- Farmer, Buyer, Extension Officer, Admin → User
- Chat → One-on-One Chat, Group Chat
- Report → Daily, Weekly, Monthly Report

---

## 9. USE CASE PRECONDITIONS & POSTCONDITIONS

### Example: Place Order

**Preconditions:**

- User is authenticated as Buyer
- Product is available
- Seller is active
- Buyer has valid contact info

**Postconditions:**

- Order is created in database
- Seller receives notification
- Buyer receives confirmation
- Order status is "pending"
- Inventory is reserved

### Example: Approve Registration

**Preconditions:**

- Admin is authenticated
- User registration is pending
- Required documents uploaded
- Documents are valid

**Postconditions:**

- User status changed to "approved"
- User receives approval notification
- User can access full features
- Audit log is updated
- Admin activity recorded

---

## 10. USE CASE PRIORITIES

### Critical (Must Have - P0)

- Register Account
- Login/Logout
- Manage Farm
- List Products
- Browse Products
- Place Order
- Get AI Assistance
- View Market Prices

### High Priority (P1)

- Chat
- Set Price Alerts
- Track Orders
- Manage Finances
- Schedule Services
- Approve Registrations
- Moderate Content

### Medium Priority (P2)

- Social Features (Posts, Groups)
- Contract Farming
- Bulk Orders
- Advanced Analytics
- Resource Library

### Low Priority (P3)

- Gamification
- Advanced Predictions
- Social Sharing
- Customization

---

## 11. USE CASE COMPLEXITY ESTIMATION

**Simple (1-3 days):**

- View Profile
- Update Settings
- View Dashboard
- Search

**Medium (3-7 days):**

- Register Account
- List Products
- Place Order
- Chat System

**Complex (1-2 weeks):**

- Price Intelligence
- AI Assistant
- Contract Management
- Extension Services

**Very Complex (2-4 weeks):**

- Full Marketplace
- Analytics Dashboard
- Approval Workflow
- Notification System

---
