<?php
require_once __DIR__ . '/../config/config.php';

if (!isLoggedIn() || getUserType() !== 'buyer') {
    header('Location: ' . APP_URL . '/auth/login.php');
    exit();
}

$pageTitle = 'Help & Support';
$breadcrumbs = [['title' => 'Help', 'url' => '']];

require_once __DIR__ . '/includes/base.php';
renderBuyerHeader($pageTitle, $breadcrumbs);
?>

<div class="row">
    <div class="col-lg-3">
        <div class="card shadow-sm sticky-top" style="top: 20px;">
            <div class="card-header bg-white py-3">
                <h6 class="mb-0">Help Topics</h6>
            </div>
            <div class="list-group list-group-flush">
                <a href="#getting-started" class="list-group-item list-group-item-action">
                    <i class="bi bi-play-circle me-2"></i>Getting Started
                </a>
                <a href="#ordering" class="list-group-item list-group-item-action">
                    <i class="bi bi-cart me-2"></i>Placing Orders
                </a>
                <a href="#bulk-orders" class="list-group-item list-group-item-action">
                    <i class="bi bi-box-seam me-2"></i>Bulk Orders
                </a>
                <a href="#payments" class="list-group-item list-group-item-action">
                    <i class="bi bi-wallet2 me-2"></i>Payments
                </a>
                <a href="#blocking" class="list-group-item list-group-item-action">
                    <i class="bi bi-shield me-2"></i>Blocking Users
                </a>
                <a href="#verification" class="list-group-item list-group-item-action">
                    <i class="bi bi-patch-check me-2"></i>Verification
                </a>
                <a href="#faq" class="list-group-item list-group-item-action">
                    <i class="bi bi-question-circle me-2"></i>FAQ
                </a>
            </div>
        </div>
    </div>
    
    <div class="col-lg-9">
        <!-- Getting Started -->
        <div class="card shadow-sm mb-4" id="getting-started">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="bi bi-play-circle me-2"></i>Getting Started</h5>
            </div>
            <div class="card-body">
                <h6>Welcome to AIMS Buyer Portal!</h6>
                <p>Follow these steps to get started:</p>
                <ol>
                    <li><strong>Complete Your Profile</strong> - Add your business information and select your buyer type</li>
                    <li><strong>Get Verified</strong> - Premium buyers (Wholesaler, Processor, Exporter) need verification</li>
                    <li><strong>Browse Products</strong> - Find agricultural products from verified farmers</li>
                    <li><strong>Place Orders</strong> - Order products directly or request bulk quotes</li>
                    <li><strong>Manage Suppliers</strong> - Build relationships with reliable farmers</li>
                </ol>
            </div>
        </div>
        
        <!-- Ordering -->
        <div class="card shadow-sm mb-4" id="ordering">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="bi bi-cart me-2"></i>Placing Orders</h5>
            </div>
            <div class="card-body">
                <h6>How to Place an Order:</h6>
                <ol>
                    <li>Browse products in the marketplace</li>
                    <li>Click on a product to view details</li>
                    <li>Enter quantity and delivery information</li>
                    <li>Review and confirm your order</li>
                    <li>Track your order status in real-time</li>
                </ol>
                
                <h6 class="mt-4">Order Status Meanings:</h6>
                <ul>
                    <li><strong>Pending</strong> - Waiting for seller confirmation</li>
                    <li><strong>Confirmed</strong> - Seller has confirmed the order</li>
                    <li><strong>Processing</strong> - Order is being prepared</li>
                    <li><strong>Completed</strong> - Order delivered successfully</li>
                    <li><strong>Cancelled</strong> - Order was cancelled</li>
                </ul>
            </div>
        </div>
        
        <!-- Bulk Orders -->
        <div class="card shadow-sm mb-4" id="bulk-orders">
            <div class="card-header bg-warning text-dark">
                <h5 class="mb-0"><i class="bi bi-box-seam me-2"></i>Bulk Orders & Smart Matching</h5>
            </div>
            <div class="card-body">
                <h6>Understanding Smart Matching:</h6>
                <p>Our system automatically matches you with appropriate suppliers based on:</p>
                
                <div class="alert alert-info">
                    <strong>Quantity-Based Matching:</strong>
                    <ul class="mb-0">
                        <li><strong>Small Quantities</strong> (&lt; 1 ton) - Individual farmers, small retailers</li>
                        <li><strong>Medium Quantities</strong> (1-5 tons) - Medium farms, wholesalers</li>
                        <li><strong>Large Quantities</strong> (5-20 tons) - Large farms, processors</li>
                        <li><strong>Very Large</strong> (&gt; 20 tons) - Commercial farms, exporters</li>
                    </ul>
                </div>
                
                <h6 class="mt-3">Product-Specific Examples:</h6>
                <div class="row">
                    <div class="col-md-6">
                        <strong>Sugar Cane:</strong>
                        <ul>
                            <li>Small: &lt; 1,000 kg - Small farmers only</li>
                            <li>Large: &gt; 20,000 kg - Only shown to processors like Kakira Sugar</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <strong>Maize:</strong>
                        <ul>
                            <li>Small: &lt; 500 kg - Local buyers</li>
                            <li>Large: &gt; 10,000 kg - Exporters and processors</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Blocking System -->
        <div class="card shadow-sm mb-4" id="blocking">
            <div class="card-header bg-danger text-white">
                <h5 class="mb-0"><i class="bi bi-shield me-2"></i>Blocking Users</h5>
            </div>
            <div class="card-body">
                <h6>Why Block Users?</h6>
                <p>You can block farmers or other buyers to prevent:</p>
                <ul>
                    <li>Seeing their products in search results</li>
                    <li>Receiving messages from them</li>
                    <li>Their bids on your bulk orders</li>
                </ul>
                
                <h6>How to Block:</h6>
                <ol>
                    <li>Go to supplier profile or chat</li>
                    <li>Click the menu (three dots)</li>
                    <li>Select "Block User"</li>
                    <li>Confirm your action</li>
                </ol>
                
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <strong>Note:</strong> Blocked users won't be notified, and you can unblock them anytime from Settings
                </div>
            </div>
        </div>
        
        <!-- Payments -->
        <div class="card shadow-sm mb-4" id="payments">
            <div class="card-header" style="background: #6366f1; color: white;">
                <h5 class="mb-0"><i class="bi bi-wallet2 me-2"></i>Payment Management</h5>
            </div>
            <div class="card-body">
                <h6>Supported Payment Methods:</h6>
                <ul>
                    <li><strong>Mobile Money</strong> - MTN, Airtel</li>
                    <li><strong>Bank Transfer</strong> - Direct bank deposits</li>
                    <li><strong>Cash on Delivery</strong> - Pay when you receive</li>
                    <li><strong>Credit Terms</strong> - For verified buyers</li>
                </ul>
                
                <h6 class="mt-3">Adding Payment Methods:</h6>
                <ol>
                    <li>Go to Payments page</li>
                    <li>Click "Add Payment Method"</li>
                    <li>Fill in your details</li>
                    <li>Set as default (optional)</li>
                </ol>
            </div>
        </div>
        
        <!-- FAQ -->
        <div class="card shadow-sm mb-4" id="faq">
            <div class="card-header" style="background: #8b5cf6; color: white;">
                <h5 class="mb-0"><i class="bi bi-question-circle me-2"></i>Frequently Asked Questions</h5>
            </div>
            <div class="card-body">
                <div class="accordion" id="faqAccordion">
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                                How long does verification take?
                            </button>
                        </h2>
                        <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Verification typically takes 1-2 business days. You'll receive a notification once approved.
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                                Can I cancel an order?
                            </button>
                        </h2>
                        <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Yes, you can cancel orders with "Pending" status. Once confirmed by the seller, cancellation requires their approval.
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3">
                                Why can't I see some suppliers?
                            </button>
                        </h2>
                        <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Suppliers are matched based on your order quantity and their capacity. Small-scale farmers won't appear for very large orders, and vice versa.
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq4">
                                How do I become a verified buyer?
                            </button>
                        </h2>
                        <div id="faq4" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Premium buyers (Wholesaler, Processor, Exporter) need to submit business registration documents and tax ID. Individual and Retailer buyers don't require verification.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Contact Support -->
        <div class="card shadow-sm">
            <div class="card-body text-center">
                <h5>Still Need Help?</h5>
                <p class="text-muted">Our support team is here to assist you</p>
                <div class="row g-3 mt-3">
                    <div class="col-md-4">
                        <i class="bi bi-envelope" style="font-size: 2rem; color: var(--primary-color);"></i>
                        <p class="mb-0 mt-2"><strong>Email</strong></p>
                        <a href="mailto:support@aims.ug">support@aims.ug</a>
                    </div>
                    <div class="col-md-4">
                        <i class="bi bi-telephone" style="font-size: 2rem; color: var(--primary-color);"></i>
                        <p class="mb-0 mt-2"><strong>Phone</strong></p>
                        <a href="tel:+256700000000">+256 700 000 000</a>
                    </div>
                    <div class="col-md-4">
                        <i class="bi bi-chat-dots" style="font-size: 2rem; color: var(--primary-color);"></i>
                        <p class="mb-0 mt-2"><strong>Live Chat</strong></p>
                        <button class="btn btn-sm btn-primary mt-2">Start Chat</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php renderBuyerFooter(); ?>