
<?php
/**
 * ============================================================================
 * FILE 2: auth/forgot-password.php
 * ============================================================================
 */
?>
<?php
define('AIMS_ACCESS', true);
require_once '../config/config.php';

if (isLoggedIn()) {
    header('Location: ../dashboard/');
    exit();
}

$pageTitle = 'Forgot Password - AIMS';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?></title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #059669;
            --primary-dark: #047857;
            --primary-light: #10b981;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .auth-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            max-width: 450px;
            width: 100%;
            overflow: hidden;
            animation: fadeInUp 0.6s ease;
        }
        
        .auth-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
            padding: 40px 30px;
            text-align: center;
            color: white;
        }
        
        .auth-logo {
            font-size: 4rem;
            margin-bottom: 15px;
        }
        
        .auth-body {
            padding: 35px 30px;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            border: none;
            padding: 12px;
            font-weight: 600;
            border-radius: 10px;
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
</head>
<body>
    <div class="auth-card">
        <div class="auth-header">
            <div class="auth-logo">🔐</div>
            <h1 class="h2 fw-bold">Forgot Password?</h1>
            <p class="mb-0">We'll send you an OTP to reset it</p>
        </div>
        
        <div class="auth-body">
            <div class="alert alert-info" role="alert">
                <i class="bi bi-info-circle me-2"></i>
                Enter your registered phone number and we'll send you an OTP to reset your password.
            </div>
            
            <form id="forgotForm" novalidate>
                <div class="mb-3">
                    <div class="form-floating">
                        <input type="tel" class="form-control" id="phone" placeholder="Phone Number" required>
                        <label for="phone"><i class="bi bi-phone me-2"></i>Phone Number</label>
                        <div class="invalid-feedback">Please enter a valid phone number</div>
                    </div>
                    <small class="text-muted">Format: 0700000000 or +256700000000</small>
                </div>
                
                <button type="submit" class="btn btn-primary w-100 mb-3">
                    <i class="bi bi-send me-2"></i>Send OTP
                </button>
            </form>
            
            <hr>
            
            <p class="text-center mb-0">
                Remember your password? <a href="login.php" class="text-decoration-none fw-bold">Login Here</a>
            </p>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
    
    <script>
        const APP_URL = '<?php echo APP_URL; ?>';
        
        function showToast(message, type = 'info') {
            const colors = {
                success: 'linear-gradient(135deg, #22c55e 0%, #16a34a 100%)',
                error: 'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)',
                warning: 'linear-gradient(135deg, #f59e0b 0%, #d97706 100%)',
                info: 'linear-gradient(135deg, #3b82f6 0%, #2563eb 100%)'
            };
            
            Toastify({
                text: message,
                duration: 3000,
                gravity: "top",
                position: "right",
                style: {
                    background: colors[type],
                    borderRadius: "10px",
                    padding: "15px 20px"
                },
                stopOnFocus: true
            }).showToast();
        }
        
        $('#forgotForm').submit(function(e) {
            e.preventDefault();
            
            if (!this.checkValidity()) {
                e.stopPropagation();
                $(this).addClass('was-validated');
                return;
            }
            
            const btn = $(this).find('button[type="submit"]');
            btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>Sending...');
            
            // For now, just show a message (implement password reset in production)
            setTimeout(() => {
                Swal.fire({
                    title: 'Feature Coming Soon!',
                    text: 'Password reset functionality will be available soon. Please contact support for assistance.',
                    icon: 'info',
                    confirmButtonColor: '#059669'
                });
                btn.prop('disabled', false).html('<i class="bi bi-send me-2"></i>Send OTP');
            }, 1000);
        });
    </script>
</body>
</html>