<?php
/**
 * ============================================================================
 * ajax/toggle-alert.php - Toggle Price Alert Status
 * ============================================================================
 */
define('AIMS_ACCESS', true);
require_once '../config/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonError('Unauthorized', 401);
}

if (!isPost()) {
    jsonError('Invalid request method');
}

$alertId = (int)($_POST['alert_id'] ?? 0);
$isActive = (int)($_POST['is_active'] ?? 0);
$userId = getUserId();

if ($alertId <= 0) {
    jsonError('Invalid alert ID');
}

$database = new Database();
$db = $database->getConnection();
$priceClass = new \App\Price($db);

$result = $priceClass->toggleAlert($alertId, $userId);

if ($result['success']) {
    logActivity($userId, 'toggle_price_alert', "Toggled alert ID {$alertId} to " . ($isActive ? 'active' : 'inactive'));
    jsonSuccess($result['message']);
} else {
    jsonError($result['message']);
}
?>
