<?php
/**
 * ============================================================================
 * ajax/mark-all-notifications-read.php
 * Mark all user notifications as read
 * ============================================================================
 */

define('AIMS_ACCESS', true);
require_once __DIR__ . '/../config/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

try {
    $userId = getUserId();
    $database = new Database();
    $db = $database->getConnection();
    
    // Mark all as read
    $sql = "UPDATE notifications SET is_read = 1 WHERE user_id = ? AND is_read = 0";
    $stmt = $db->prepare($sql);
    $stmt->execute([$userId]);
    
    echo json_encode([
        'success' => true,
        'message' => 'All notifications marked as read',
        'updated_count' => $stmt->rowCount()
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Failed to mark notifications as read'
    ]);
}
?>