<?php
/**
 * ============================================================================
 * ajax/get-subcounties.php
 * Get subcounties by district
 * ============================================================================
 */
define('AIMS_ACCESS', true);
require_once '../config/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonError('Unauthorized', 401);
}

$districtId = (int)($_GET['district_id'] ?? 0);

if ($districtId <= 0) {
    jsonError('Invalid district ID');
}

$database = new Database();
$db = $database->getConnection();

$sql = "SELECT id, subcounty_name FROM subcounties WHERE district_id = ? ORDER BY subcounty_name";
$stmt = $db->prepare($sql);
$stmt->execute([$districtId]);
$subcounties = $stmt->fetchAll();

echo json_encode($subcounties);
?>
