<?php
/**
 * ============================================================================
 * ajax/delete-transaction.php - Delete Transaction
 * ============================================================================
 */
define('AIMS_ACCESS', true);
require_once __DIR__ . '/../config/config.php';

header('Content-Type: application/json');

// Check authentication
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Please login first']);
    exit;
}

// Check request method
if (!isPost()) {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

$userId = getUserId();
$transactionId = $_POST['transaction_id'] ?? null;

if (!$transactionId) {
    echo json_encode(['success' => false, 'message' => 'Transaction ID is required']);
    exit;
}

try {
    // Get database connection
    $database = new Database();
    $db = $database->getConnection();
    
    // Initialize transaction class
    $transactionClass = new \App\Transaction($db);
    
    // Delete transaction
    $result = $transactionClass->delete($transactionId, $userId);
    
    echo json_encode($result);
    
} catch (Exception $e) {
    error_log("Delete transaction error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'An error occurred while deleting the transaction'
    ]);
}
?>