<?php
/**
 * ============================================================================
 * ajax/delete-reminder.php - Delete Farming Reminder
 * ============================================================================
 */
define('AIMS_ACCESS', true);
require_once __DIR__ . '/../config/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit;
}

if (!isset($_POST['id'])) {
    echo json_encode(['success' => false, 'message' => 'Reminder ID required']);
    exit;
}

$reminderId = intval($_POST['id']);
$userId = getUserId();

try {
    $database = new Database();
    $db = $database->getConnection();
    
    // Delete reminder (will verify ownership via WHERE clause)
    $sql = "DELETE FROM user_farming_reminders WHERE id = ? AND user_id = ?";
    $stmt = $db->prepare($sql);
    $stmt->execute([$reminderId, $userId]);
    
    if ($stmt->rowCount() > 0) {
        echo json_encode([
            'success' => true,
            'message' => 'Reminder deleted successfully'
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Reminder not found or already deleted'
        ]);
    }
    
} catch (PDOException $e) {
    error_log("Database error in delete-reminder.php: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Failed to delete reminder'
    ]);
}
?>