<?php
/**
 * ============================================================================
 * ajax/delete-alert.php - Delete Price Alert
 * ============================================================================
 */
define('AIMS_ACCESS', true);
require_once '../config/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonError('Unauthorized', 401);
}

if (!isPost()) {
    jsonError('Invalid request method');
}

$alertId = (int)($_POST['alert_id'] ?? 0);
$userId = getUserId();

if ($alertId <= 0) {
    jsonError('Invalid alert ID');
}

$database = new Database();
$db = $database->getConnection();
$priceClass = new \App\Price($db);

$result = $priceClass->deleteAlert($alertId, $userId);

if ($result['success']) {
    logActivity($userId, 'delete_price_alert', "Deleted alert ID {$alertId}");
    jsonSuccess($result['message']);
} else {
    jsonError($result['message']);
}
?>
