<?php
/**
 * ============================================================================
 * ai-assistant/ajax/history.php - Session-based History
 * ============================================================================
 */

define('AIMS_ACCESS', true);
require_once __DIR__ . '/../../config/config.php';

header('Content-Type: application/json; charset=utf-8');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

try {
    $userId = getUserId();
    
    require_once __DIR__ . '/../../classes/AIAssistant.php';
    $ai = new \App\AIAssistant();
    
    // Get all sessions for this user
    $sessions = $ai->getUserSessions($userId, 50);
    
    echo json_encode([
        'success' => true,
        'sessions' => $sessions
    ]);
    
} catch (Exception $e) {
    error_log('History Error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error loading history'
    ]);
}