<?php
/**
 * Admin Sidebar Navigation - COMPREHENSIVE UPDATE
 * File: admin/includes/admin-sidebar.php
 */

$currentPage = basename($_SERVER['PHP_SELF']);

// Get pending counts
try {
    $sql = "SELECT 
                (SELECT COUNT(*) FROM user_approvals WHERE approval_status = 'pending') as pending_approvals,
                (SELECT COUNT(*) FROM reports WHERE status = 'pending') as pending_reports,
                (SELECT COUNT(*) FROM user_reports WHERE status = 'pending') as pending_user_reports,
                (SELECT COUNT(*) FROM message_reports WHERE status = 'pending') as pending_message_reports,
                (SELECT COUNT(*) FROM price_reports WHERE verification_status = 'pending') as pending_price_reports";
    $stmt = $db->query($sql);
    $counts = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $counts = [
        'pending_approvals' => 0, 
        'pending_reports' => 0,
        'pending_user_reports' => 0,
        'pending_message_reports' => 0,
        'pending_price_reports' => 0
    ];
}
?>

<!-- Admin Sidebar -->
<div class="admin-sidebar">
    <!-- Dashboard -->
    <div class="nav-section-title">Main</div>
    <a href="<?php echo APP_URL; ?>/admin/index.php" class="nav-link <?php echo $currentPage === 'index.php' ? 'active' : ''; ?>">
        <i class="bi bi-speedometer2"></i>
        <span>Dashboard</span>
    </a>

    <?php if (hasAdminPermission('view_analytics')): ?>
    <a href="<?php echo APP_URL; ?>/admin/analytics.php" class="nav-link <?php echo $currentPage === 'analytics.php' ? 'active' : ''; ?>">
        <i class="bi bi-graph-up"></i>
        <span>Analytics</span>
    </a>
    <?php endif; ?>

    <!-- User Management -->
    <?php if (hasAdminPermission('manage_users') || hasAdminPermission('approve_users')): ?>
    <div class="nav-section-title">User Management</div>
    
    <?php if (hasAdminPermission('approve_users')): ?>
    <a href="<?php echo APP_URL; ?>/admin/approvals.php" class="nav-link <?php echo $currentPage === 'approvals.php' ? 'active' : ''; ?>">
        <i class="bi bi-hourglass-split"></i>
        <span>Approvals</span>
        <?php if ($counts['pending_approvals'] > 0): ?>
        <span class="badge bg-warning"><?php echo $counts['pending_approvals']; ?></span>
        <?php endif; ?>
    </a>
    <?php endif; ?>

    <?php if (hasAdminPermission('manage_users')): ?>
    <a href="<?php echo APP_URL; ?>/admin/create-extension-worker.php" class="nav-link <?php echo $currentPage === 'create-extension-worker.php' ? 'active' : ''; ?>">
        <i class="bi bi-person-badge-fill"></i>
        <span>New Extension Worker</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/create-buyer.php" class="nav-link <?php echo $currentPage === 'create-buyer.php' ? 'active' : ''; ?>">
        <i class="bi bi-cart-plus-fill"></i>
        <span>New Buyer</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/extension-assignments.php" class="nav-link <?php echo $currentPage === 'extension-assignments.php' ? 'active' : ''; ?>">
        <i class="bi bi-diagram-3-fill"></i>
        <span>Extension Assignments</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/users.php" class="nav-link <?php echo $currentPage === 'users.php' ? 'active' : ''; ?>">
        <i class="bi bi-people"></i>
        <span>All Users</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/admins.php" class="nav-link <?php echo $currentPage === 'admins.php' ? 'active' : ''; ?>">
        <i class="bi bi-shield-check"></i>
        <span>Admin Users</span>
    </a>
    <?php endif; ?>
    <?php endif; ?>

    <!-- Content Management -->
    <?php if (hasAdminPermission('manage_products') || hasAdminPermission('manage_prices') || hasAdminPermission('manage_content')): ?>
    <div class="nav-section-title">Content</div>
    
    <?php if (hasAdminPermission('manage_products')): ?>
    <a href="<?php echo APP_URL; ?>/admin/products.php" class="nav-link <?php echo $currentPage === 'products.php' ? 'active' : ''; ?>">
        <i class="bi bi-box-seam"></i>
        <span>Products</span>
    </a>
    <?php endif; ?>

    <?php if (hasAdminPermission('manage_prices')): ?>
    <a href="<?php echo APP_URL; ?>/admin/market-prices.php" class="nav-link <?php echo $currentPage === 'market-prices.php' ? 'active' : ''; ?>">
        <i class="bi bi-currency-dollar"></i>
        <span>Market Prices</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/price-reports.php" class="nav-link <?php echo $currentPage === 'price-reports.php' ? 'active' : ''; ?>">
        <i class="bi bi-clipboard-check"></i>
        <span>Price Reports</span>
        <?php if ($counts['pending_price_reports'] > 0): ?>
        <span class="badge bg-info"><?php echo $counts['pending_price_reports']; ?></span>
        <?php endif; ?>
    </a>
    <?php endif; ?>

    <?php if (hasAdminPermission('manage_content')): ?>
    <a href="<?php echo APP_URL; ?>/admin/tips.php" class="nav-link <?php echo $currentPage === 'tips.php' ? 'active' : ''; ?>">
        <i class="bi bi-lightbulb"></i>
        <span>Agricultural Tips</span>
    </a>
    <?php endif; ?>
    <?php endif; ?>

    <!-- Data Management -->
    <?php if (hasAdminPermission('manage_locations') || hasAdminPermission('view_orders')): ?>
    <div class="nav-section-title">Data</div>
    
    <?php if (hasAdminPermission('manage_locations')): ?>
    <a href="<?php echo APP_URL; ?>/admin/locations.php" class="nav-link <?php echo $currentPage === 'locations.php' ? 'active' : ''; ?>">
        <i class="bi bi-geo-alt"></i>
        <span>Locations</span>
    </a>
    <?php endif; ?>

    <?php if (hasAdminPermission('view_orders')): ?>
    <a href="<?php echo APP_URL; ?>/admin/orders.php" class="nav-link <?php echo $currentPage === 'orders.php' ? 'active' : ''; ?>">
        <i class="bi bi-cart3"></i>
        <span>Orders</span>
    </a>
    <?php endif; ?>
    <?php endif; ?>

    <!-- Reports & Moderation -->
    <?php if (hasAdminPermission('manage_reports') || hasAdminPermission('moderate_content')): ?>
    <div class="nav-section-title">Moderation</div>
    
    <?php if (hasAdminPermission('manage_reports')): ?>
    <a href="<?php echo APP_URL; ?>/admin/reports.php" class="nav-link <?php echo $currentPage === 'reports.php' ? 'active' : ''; ?>">
        <i class="bi bi-flag"></i>
        <span>General Reports</span>
        <?php if ($counts['pending_reports'] > 0): ?>
        <span class="badge bg-danger"><?php echo $counts['pending_reports']; ?></span>
        <?php endif; ?>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/user-reports.php" class="nav-link <?php echo $currentPage === 'user-reports.php' ? 'active' : ''; ?>">
        <i class="bi bi-person-x"></i>
        <span>User Reports</span>
        <?php if ($counts['pending_user_reports'] > 0): ?>
        <span class="badge bg-danger"><?php echo $counts['pending_user_reports']; ?></span>
        <?php endif; ?>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/message-reports.php" class="nav-link <?php echo $currentPage === 'message-reports.php' ? 'active' : ''; ?>">
        <i class="bi bi-chat-square-text"></i>
        <span>Message Reports</span>
        <?php if ($counts['pending_message_reports'] > 0): ?>
        <span class="badge bg-danger"><?php echo $counts['pending_message_reports']; ?></span>
        <?php endif; ?>
    </a>
    <?php endif; ?>
    <?php endif; ?>

    <!-- Server & Infrastructure (Super Admin + IT) -->
    <?php if (hasAdminPermission('manage_server') || hasAdminPermission('view_server_stats')): ?>
    <div class="nav-section-title">Infrastructure</div>
    
    <?php if (hasAdminPermission('view_server_stats')): ?>
    <a href="<?php echo APP_URL; ?>/admin/server-status.php" class="nav-link <?php echo $currentPage === 'server-status.php' ? 'active' : ''; ?>">
        <i class="bi bi-hdd-rack"></i>
        <span>Server Status</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/performance.php" class="nav-link <?php echo $currentPage === 'performance.php' ? 'active' : ''; ?>">
        <i class="bi bi-speedometer"></i>
        <span>Performance</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/network-usage.php" class="nav-link <?php echo $currentPage === 'network-usage.php' ? 'active' : ''; ?>">
        <i class="bi bi-router"></i>
        <span>Network Usage</span>
    </a>
    <?php endif; ?>
    
    <?php if (hasAdminPermission('manage_server')): ?>
    <a href="<?php echo APP_URL; ?>/admin/database-manager.php" class="nav-link <?php echo $currentPage === 'database-manager.php' ? 'active' : ''; ?>">
        <i class="bi bi-database"></i>
        <span>Database Manager</span>
    </a>
    <?php endif; ?>
    <?php endif; ?>

    <!-- Security & Compliance -->
    <?php if (hasAdminPermission('manage_security') || hasAdminPermission('view_security_logs')): ?>
    <div class="nav-section-title">Security</div>
    
    <?php if (hasAdminPermission('view_security_logs')): ?>
    <a href="<?php echo APP_URL; ?>/admin/security-dashboard.php" class="nav-link <?php echo $currentPage === 'security-dashboard.php' ? 'active' : ''; ?>">
        <i class="bi bi-shield-lock"></i>
        <span>Security Dashboard</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/threat-detection.php" class="nav-link <?php echo $currentPage === 'threat-detection.php' ? 'active' : ''; ?>">
        <i class="bi bi-exclamation-triangle"></i>
        <span>Threat Detection</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/encryption-audit.php" class="nav-link <?php echo $currentPage === 'encryption-audit.php' ? 'active' : ''; ?>">
        <i class="bi bi-file-lock"></i>
        <span>Encryption Audit</span>
    </a>
    <?php endif; ?>
    
    <?php if (hasAdminPermission('manage_security')): ?>
    <a href="<?php echo APP_URL; ?>/admin/firewall-rules.php" class="nav-link <?php echo $currentPage === 'firewall-rules.php' ? 'active' : ''; ?>">
        <i class="bi bi-shield-fill-exclamation"></i>
        <span>Firewall Rules</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/ip-blacklist.php" class="nav-link <?php echo $currentPage === 'ip-blacklist.php' ? 'active' : ''; ?>">
        <i class="bi bi-ban"></i>
        <span>IP Blacklist</span>
    </a>
    <?php endif; ?>
    <?php endif; ?>

    <!-- Backups & Recovery -->
    <?php if (hasAdminPermission('manage_backups')): ?>
    <div class="nav-section-title">Backups</div>
    
    <a href="<?php echo APP_URL; ?>/admin/backup-manager.php" class="nav-link <?php echo $currentPage === 'backup-manager.php' ? 'active' : ''; ?>">
        <i class="bi bi-save"></i>
        <span>Backup Manager</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/restore.php" class="nav-link <?php echo $currentPage === 'restore.php' ? 'active' : ''; ?>">
        <i class="bi bi-arrow-counterclockwise"></i>
        <span>Restore Data</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/disaster-recovery.php" class="nav-link <?php echo $currentPage === 'disaster-recovery.php' ? 'active' : ''; ?>">
        <i class="bi bi-life-preserver"></i>
        <span>Disaster Recovery</span>
    </a>
    <?php endif; ?>

    <!-- Audit & Logs -->
    <?php if (hasAdminPermission('view_logs') || hasAdminPermission('view_audit_logs')): ?>
    <div class="nav-section-title">Audit & Logs</div>
    
    <?php if (hasAdminPermission('view_logs')): ?>
    <a href="<?php echo APP_URL; ?>/admin/logs.php" class="nav-link <?php echo $currentPage === 'logs.php' ? 'active' : ''; ?>">
        <i class="bi bi-clock-history"></i>
        <span>Activity Logs</span>
    </a>
    <?php endif; ?>
    
    <?php if (hasAdminPermission('view_audit_logs')): ?>
    <a href="<?php echo APP_URL; ?>/admin/audit-trail.php" class="nav-link <?php echo $currentPage === 'audit-trail.php' ? 'active' : ''; ?>">
        <i class="bi bi-journal-text"></i>
        <span>Audit Trail</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/admin-activity.php" class="nav-link <?php echo $currentPage === 'admin-activity.php' ? 'active' : ''; ?>">
        <i class="bi bi-person-lines-fill"></i>
        <span>Admin Activity</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/system-events.php" class="nav-link <?php echo $currentPage === 'system-events.php' ? 'active' : ''; ?>">
        <i class="bi bi-file-earmark-text"></i>
        <span>System Events</span>
    </a>
    <?php endif; ?>
    <?php endif; ?>

    <!-- System Configuration -->
    <?php if (hasAdminPermission('manage_settings') || hasAdminPermission('manage_roles')): ?>
    <div class="nav-section-title">System</div>
    
    <?php if (hasAdminPermission('manage_roles')): ?>
    <a href="<?php echo APP_URL; ?>/admin/roles.php" class="nav-link <?php echo $currentPage === 'roles.php' ? 'active' : ''; ?>">
        <i class="bi bi-key"></i>
        <span>Roles & Permissions</span>
    </a>
    <?php endif; ?>

    <?php if (hasAdminPermission('manage_settings')): ?>
    <a href="<?php echo APP_URL; ?>/admin/settings.php" class="nav-link <?php echo $currentPage === 'settings.php' ? 'active' : ''; ?>">
        <i class="bi bi-gear"></i>
        <span>Settings</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/maintenance-mode.php" class="nav-link <?php echo $currentPage === 'maintenance-mode.php' ? 'active' : ''; ?>">
        <i class="bi bi-tools"></i>
        <span>Maintenance Mode</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/admin/email-config.php" class="nav-link <?php echo $currentPage === 'email-config.php' ? 'active' : ''; ?>">
        <i class="bi bi-envelope-at"></i>
        <span>Email Configuration</span>
    </a>
    <?php endif; ?>
    <?php endif; ?>

    <!-- Help & Documentation -->
    <div class="nav-section-title">Help</div>
    <a href="<?php echo APP_URL; ?>/admin/help.php" class="nav-link <?php echo $currentPage === 'help.php' ? 'active' : ''; ?>">
        <i class="bi bi-question-circle"></i>
        <span>Documentation</span>
    </a>
    
    <?php if (hasAdminPermission('manage_settings')): ?>
    <a href="<?php echo APP_URL; ?>/admin/api-documentation.php" class="nav-link <?php echo $currentPage === 'api-documentation.php' ? 'active' : ''; ?>">
        <i class="bi bi-code-square"></i>
        <span>API Docs</span>
    </a>
    <?php endif; ?>
</div>