<?php
require_once __DIR__ . '/includes/base.php';
$breadcrumbs = [['title' => 'Help & Documentation', 'url' => '']];
renderAdminHeader('Help & Documentation', $breadcrumbs);
?>

<div class="mb-4">
    <h2 class="fw-bold">Admin Panel Documentation</h2>
    <p class="text-muted">Complete guide to using the AIMS admin panel</p>
</div>

<div class="row">
    <div class="col-md-3 mb-4">
        <div class="list-group" id="helpNav">
            <a href="#getting-started" class="list-group-item list-group-item-action active" data-bs-toggle="list">
                <i class="bi bi-play-circle me-2"></i>Getting Started
            </a>
            <a href="#user-management" class="list-group-item list-group-item-action" data-bs-toggle="list">
                <i class="bi bi-people me-2"></i>User Management
            </a>
            <a href="#approvals" class="list-group-item list-group-item-action" data-bs-toggle="list">
                <i class="bi bi-check-circle me-2"></i>Approvals
            </a>
            <a href="#products" class="list-group-item list-group-item-action" data-bs-toggle="list">
                <i class="bi bi-box me-2"></i>Products
            </a>
            <a href="#orders" class="list-group-item list-group-item-action" data-bs-toggle="list">
                <i class="bi bi-cart me-2"></i>Orders
            </a>
            <a href="#prices" class="list-group-item list-group-item-action" data-bs-toggle="list">
                <i class="bi bi-currency-dollar me-2"></i>Market Prices
            </a>
            <a href="#locations" class="list-group-item list-group-item-action" data-bs-toggle="list">
                <i class="bi bi-geo-alt me-2"></i>Locations
            </a>
            <a href="#security" class="list-group-item list-group-item-action" data-bs-toggle="list">
                <i class="bi bi-shield me-2"></i>Security
            </a>
            <a href="#troubleshooting" class="list-group-item list-group-item-action" data-bs-toggle="list">
                <i class="bi bi-tools me-2"></i>Troubleshooting
            </a>
        </div>
    </div>
    
    <div class="col-md-9">
        <div class="tab-content">
            <!-- Getting Started -->
            <div class="tab-pane fade show active" id="getting-started">
                <div class="card shadow-sm border-0">
                    <div class="card-body">
                        <h3><i class="bi bi-play-circle text-primary me-2"></i>Getting Started</h3>
                        <hr>
                        
                        <h5>Welcome to AIMS Admin Panel</h5>
                        <p>The AIMS Admin Panel allows you to manage all aspects of the Agricultural Information & Market Linkage System.</p>
                        
                        <h6 class="mt-4">Dashboard Overview</h6>
                        <p>The dashboard provides at-a-glance statistics including:</p>
                        <ul>
                            <li>Total registered users (farmers, buyers, officers)</li>
                            <li>Pending approvals requiring action</li>
                            <li>Active products in marketplace</li>
                            <li>Recent system activity</li>
                        </ul>
                        
                        <h6 class="mt-4">Quick Actions</h6>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="bg-light p-3 rounded mb-3">
                                    <h6><i class="bi bi-check-circle text-success"></i> Approve Users</h6>
                                    <p class="small mb-0">Review and approve buyer/officer registrations</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="bg-light p-3 rounded mb-3">
                                    <h6><i class="bi bi-currency-dollar text-info"></i> Update Prices</h6>
                                    <p class="small mb-0">Add daily market price data</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- User Management -->
            <div class="tab-pane fade" id="user-management">
                <div class="card shadow-sm border-0">
                    <div class="card-body">
                        <h3><i class="bi bi-people text-primary me-2"></i>User Management</h3>
                        <hr>
                        
                        <h5>Viewing Users</h5>
                        <p>Access all registered users from <code>/admin/users.php</code></p>
                        <ul>
                            <li>Search and filter by user type, status, location</li>
                            <li>View detailed user profiles</li>
                            <li>Track user activity (products, orders)</li>
                        </ul>
                        
                        <h5 class="mt-4">Editing Users</h5>
                        <p>Click the <span class="badge bg-primary">Edit</span> button to modify:</p>
                        <ul>
                            <li>Full name</li>
                            <li>Email address</li>
                            <li>User status (active/inactive)</li>
                        </ul>
                        
                        <div class="alert alert-warning">
                            <i class="bi bi-exclamation-triangle me-2"></i>
                            <strong>Note:</strong> Phone numbers and user types cannot be changed for security reasons.
                        </div>
                        
                        <h5 class="mt-4">Deactivating Users</h5>
                        <p>To temporarily disable a user account:</p>
                        <ol>
                            <li>Find the user in the users table</li>
                            <li>Click <span class="badge bg-warning">Deactivate</span></li>
                            <li>Confirm the action</li>
                        </ol>
                        <p>Deactivated users cannot login but their data remains intact.</p>
                    </div>
                </div>
            </div>

            <!-- Approvals -->
            <div class="tab-pane fade" id="approvals">
                <div class="card shadow-sm border-0">
                    <div class="card-body">
                        <h3><i class="bi bi-check-circle text-primary me-2"></i>User Approvals</h3>
                        <hr>
                        
                        <h5>Why Approvals?</h5>
                        <p>Buyer and Extension Officer registrations require admin approval to:</p>
                        <ul>
                            <li>Verify legitimate business credentials</li>
                            <li>Prevent fraudulent accounts</li>
                            <li>Ensure quality marketplace participants</li>
                        </ul>
                        
                        <h5 class="mt-4">Approval Process</h5>
                        <ol>
                            <li>Navigate to <code>/admin/approvals.php</code></li>
                            <li>Review applicant information</li>
                            <li>Verify supporting documents (if provided)</li>
                            <li>Click <span class="badge bg-success">Approve</span> or <span class="badge bg-danger">Reject</span></li>
                        </ol>
                        
                        <h6 class="mt-3">What to Check:</h6>
                        <ul>
                            <li><strong>Buyers:</strong> Business name, registration number, tax ID</li>
                            <li><strong>Officers:</strong> Organization, qualifications, license</li>
                        </ul>
                        
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            Approved users receive automatic SMS notification
                        </div>
                    </div>
                </div>
            </div>

            <!-- Products -->
            <div class="tab-pane fade" id="products">
                <div class="card shadow-sm border-0">
                    <div class="card-body">
                        <h3><i class="bi bi-box text-primary me-2"></i>Product Management</h3>
                        <hr>
                        
                        <p>Monitor and moderate all marketplace listings.</p>
                        
                        <h5>Product Moderation</h5>
                        <p>Admins can:</p>
                        <ul>
                            <li>View all active and sold products</li>
                            <li>Remove inappropriate listings</li>
                            <li>Track product views and interest</li>
                            <li>View seller information</li>
                        </ul>
                        
                        <h5 class="mt-4">When to Remove Products</h5>
                        <ul>
                            <li>Fraudulent or misleading listings</li>
                            <li>Prohibited items</li>
                            <li>Duplicate postings</li>
                            <li>User reports verified as valid</li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Orders -->
            <div class="tab-pane fade" id="orders">
                <div class="card shadow-sm border-0">
                    <div class="card-body">
                        <h3><i class="bi bi-cart text-primary me-2"></i>Order Management</h3>
                        <hr>
                        
                        <h5>Admin Intervention</h5>
                        <p>Admins can intervene when disputes arise between buyers and sellers.</p>
                        
                        <h6>Intervention Actions:</h6>
                        <ul>
                            <li><strong>Cancel Order:</strong> Void the transaction</li>
                            <li><strong>Issue Refund:</strong> Return payment to buyer</li>
                            <li><strong>Mark Resolved:</strong> Close dispute favorably</li>
                            <li><strong>Escalate:</strong> Flag for senior review</li>
                        </ul>
                        
                        <div class="alert alert-warning">
                            <i class="bi bi-shield-exclamation me-2"></i>
                            <strong>Important:</strong> All interventions are logged and both parties are notified
                        </div>
                        
                        <h6 class="mt-3">Common Scenarios:</h6>
                        <ol>
                            <li>Product quality disputes</li>
                            <li>Delivery issues</li>
                            <li>Payment problems</li>
                            <li>Miscommunication</li>
                        </ol>
                    </div>
                </div>
            </div>

            <!-- Market Prices -->
            <div class="tab-pane fade" id="prices">
                <div class="card shadow-sm border-0">
                    <div class="card-body">
                        <h3><i class="bi bi-currency-dollar text-primary me-2"></i>Market Prices</h3>
                        <hr>
                        
                        <h5>Adding Prices</h5>
                        <ol>
                            <li>Click <span class="badge bg-primary">Add Price</span></li>
                            <li>Select or enter product name</li>
                            <li>Enter market location</li>
                            <li>Input price and unit</li>
                            <li>Specify source (e.g., "Market Survey", "Direct Contact")</li>
                            <li>Set date</li>
                            <li>Save</li>
                        </ol>
                        
                        <h5 class="mt-4">Best Practices</h5>
                        <ul>
                            <li>Update prices daily for major products</li>
                            <li>Use consistent product names</li>
                            <li>Verify prices before entry</li>
                            <li>Document your source</li>
                        </ul>
                        
                        <h5 class="mt-4">CSV Import</h5>
                        <p>Bulk import prices:</p>
                        <ol>
                            <li>Prepare CSV file with columns: product_type, market_location, price, unit, source, price_date</li>
                            <li>Click <span class="badge bg-success">Import CSV</span></li>
                            <li>Select file and upload</li>
                        </ol>
                    </div>
                </div>
            </div>

            <!-- Locations -->
            <div class="tab-pane fade" id="locations">
                <div class="card shadow-sm border-0">
                    <div class="card-body">
                        <h3><i class="bi bi-geo-alt text-primary me-2"></i>Location Management</h3>
                        <hr>
                        
                        <h5>5-Level Hierarchy</h5>
                        <p>Uganda's administrative structure:</p>
                        <ol>
                            <li><strong>Region:</strong> Busoga, Central, Eastern, etc.</li>
                            <li><strong>District:</strong> Luuka, Jinja, Iganga, etc.</li>
                            <li><strong>Subcounty:</strong> Bukanga, Irongo, etc.</li>
                            <li><strong>Parish:</strong> Local administrative units</li>
                            <li><strong>Village:</strong> Smallest administrative unit</li>
                        </ol>
                        
                        <h5 class="mt-4">Adding Locations</h5>
                        <p>Always add in hierarchical order (top-down):</p>
                        <ul>
                            <li>Add Region first</li>
                            <li>Then Districts under that Region</li>
                            <li>Then Subcounties under Districts</li>
                            <li>And so on...</li>
                        </ul>
                        
                        <div class="alert alert-info">
                            <i class="bi bi-lightbulb me-2"></i>
                            <strong>Tip:</strong> Villages can have the same name if they're in different parishes
                        </div>
                    </div>
                </div>
            </div>

            <!-- Security -->
            <div class="tab-pane fade" id="security">
                <div class="card shadow-sm border-0">
                    <div class="card-body">
                        <h3><i class="bi bi-shield text-primary me-2"></i>Security Features</h3>
                        <hr>
                        
                        <h5>Activity Monitoring</h5>
                        <p>The system tracks:</p>
                        <ul>
                            <li>All admin actions (create, update, delete)</li>
                            <li>User login attempts (successful and failed)</li>
                            <li>IP addresses and user agents</li>
                            <li>Data changes (before and after)</li>
                        </ul>
                        
                        <h5 class="mt-4">Failed Login Protection</h5>
                        <ul>
                            <li>3 failed attempts = account locked for 15 minutes</li>
                            <li>5 failed attempts = account locked for 1 hour</li>
                            <li>Admins receive alerts for suspicious activity</li>
                        </ul>
                        
                        <h5 class="mt-4">IP Blocking</h5>
                        <p>Block malicious IPs from Security Events tab:</p>
                        <ol>
                            <li>Navigate to Activity Logs → Security Events</li>
                            <li>Identify suspicious IP</li>
                            <li>Click <span class="badge bg-danger">Block IP</span></li>
                        </ol>
                        
                        <div class="alert alert-danger">
                            <i class="bi bi-exclamation-octagon me-2"></i>
                            <strong>Warning:</strong> Blocked IPs cannot access the system at all
                        </div>
                    </div>
                </div>
            </div>

            <!-- Troubleshooting -->
            <div class="tab-pane fade" id="troubleshooting">
                <div class="card shadow-sm border-0">
                    <div class="card-body">
                        <h3><i class="bi bi-tools text-primary me-2"></i>Troubleshooting</h3>
                        <hr>
                        
                        <h5>Common Issues</h5>
                        
                        <div class="accordion" id="faqAccordion">
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                                        Modal doesn't open when clicking buttons
                                    </button>
                                </h2>
                                <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                                    <div class="accordion-body">
                                        <strong>Solution:</strong>
                                        <ol>
                                            <li>Clear your browser cache (Ctrl+Shift+Delete)</li>
                                            <li>Hard refresh the page (Ctrl+F5)</li>
                                            <li>Try in incognito/private mode</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                                        "Connection error" when saving data
                                    </button>
                                </h2>
                                <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                    <div class="accordion-body">
                                        <strong>Possible causes:</strong>
                                        <ul>
                                            <li>Database connection lost</li>
                                            <li>Server timeout</li>
                                            <li>Network issues</li>
                                        </ul>
                                        <strong>Solutions:</strong>
                                        <ol>
                                            <li>Check your internet connection</li>
                                            <li>Refresh the page and try again</li>
                                            <li>Contact system administrator if persists</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3">
                                        Permission denied errors
                                    </button>
                                </h2>
                                <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                    <div class="accordion-body">
                                        Your admin role may not have required permissions.
                                        <br><br>
                                        <strong>Solution:</strong> Contact a Super Administrator to grant you the necessary permissions.
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <h5 class="mt-4">Contact Support</h5>
                        <p>If issues persist:</p>
                        <ul>
                            <li>Email: <a href="mailto:support@aims.ug">support@aims.ug</a></li>
                            <li>Phone: +256 787 842 061</li>
                            <li>Include error messages and screenshots</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php renderAdminFooter(); ?>