<?php
/**
 * Profile Settings Page - Privacy & Preferences
 * File: profile/settings.php
 * Student: Musumba Jonathan (21/BCS/010/UMC)
 */

define('AIMS_ACCESS', true);
require_once __DIR__ . '/../config/config.php';

requireLogin();

$pageTitle = 'Profile Settings';
$currentUserId = getUserId();

// Get database connection
$database = \App\Database::getInstance();
$db = $database->getConnection();
$profileClass = new \App\Profile($db);

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    if (isset($_POST['update_privacy'])) {
        $settings = [
            'show_phone' => isset($_POST['show_phone']) ? 1 : 0,
            'show_location' => isset($_POST['show_location']) ? 1 : 0,
            'show_email' => isset($_POST['show_email']) ? 1 : 0,
            'show_birthday' => isset($_POST['show_birthday']) ? 1 : 0,
            'allow_messages' => isset($_POST['allow_messages']) ? 1 : 0,
            'allow_friend_requests' => isset($_POST['allow_friend_requests']) ? 1 : 0,
            'profile_visibility' => $_POST['profile_visibility'] ?? 'public'
        ];
        
        $result = $profileClass->updatePrivacySettings($currentUserId, $settings);
        
        if ($result['success']) {
            $success_message = $result['message'];
        } else {
            $error_message = $result['message'];
        }
    }
    
    if (isset($_POST['update_notifications'])) {
        $prefs = [
            'email_notifications' => isset($_POST['email_notifications']) ? 1 : 0,
            'sms_notifications' => isset($_POST['sms_notifications']) ? 1 : 0,
            'push_notifications' => isset($_POST['push_notifications']) ? 1 : 0,
            'friend_request_notifications' => isset($_POST['friend_request_notifications']) ? 1 : 0,
            'message_notifications' => isset($_POST['message_notifications']) ? 1 : 0,
            'post_notifications' => isset($_POST['post_notifications']) ? 1 : 0
        ];
        
        $result = $profileClass->updateNotificationPreferences($currentUserId, $prefs);
        
        if ($result['success']) {
            $success_message = $result['message'];
        } else {
            $error_message = $result['message'];
        }
    }
}

// Get current settings
try {
    $stmt = $db->prepare("
        SELECT up.*, uf.* 
        FROM user_profiles up
        LEFT JOIN user_preferences uf ON up.user_id = uf.user_id
        WHERE up.user_id = ?
    ");
    $stmt->execute([$currentUserId]);
    $settings = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    error_log("Get settings error: " . $e->getMessage());
    $settings = [];
}

include_once __DIR__ . '/../includes/meta.php';
include_once __DIR__ . '/../includes/header.php';
?>

<style>
.settings-card {
    margin-bottom: 20px;
}

.settings-section {
    padding: 20px;
}

.setting-item {
    padding: 15px;
    border-bottom: 1px solid #e0e0e0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.setting-item:last-child {
    border-bottom: none;
}

.setting-info h6 {
    margin: 0;
    font-weight: 600;
    color: #333;
}

.setting-info p {
    margin: 5px 0 0 0;
    font-size: 0.85rem;
    color: #666;
}

.form-switch {
    padding-left: 2.5em;
}

.form-switch .form-check-input {
    width: 3em;
    height: 1.5em;
    cursor: pointer;
}

.nav-tabs .nav-link {
    color: #666;
}

.nav-tabs .nav-link.active {
    color: #667eea;
    border-bottom: 3px solid #667eea;
}

.alert-info-custom {
    background: linear-gradient(135deg, #667eea1a 0%, #764ba21a 100%);
    border-left: 4px solid #667eea;
    padding: 15px;
    border-radius: 8px;
    margin-bottom: 20px;
}
</style>

<div class="container my-4">
    <div class="row">
        <!-- Side Navigation -->
        <div class="col-lg-3">
            <div class="card sticky-top" style="top: 80px;">
                <div class="card-body">
                    <h6 class="mb-3">Settings</h6>
                    <nav class="nav flex-column">
                        <a class="nav-link active" href="#privacy">
                            <i class="bi bi-shield-lock"></i> Privacy
                        </a>
                        <a class="nav-link" href="#notifications">
                            <i class="bi bi-bell"></i> Notifications
                        </a>
                        <a class="nav-link" href="#account">
                            <i class="bi bi-person-gear"></i> Account
                        </a>
                        <a class="nav-link" href="<?php echo APP_URL; ?>/profile/">
                            <i class="bi bi-arrow-left"></i> Back to Profile
                        </a>
                    </nav>
                </div>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="col-lg-9">
            
            <?php if (isset($success_message)): ?>
                <div class="alert alert-success alert-dismissible fade show">
                    <i class="bi bi-check-circle"></i> <?php echo htmlspecialchars($success_message); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            
            <?php if (isset($error_message)): ?>
                <div class="alert alert-danger alert-dismissible fade show">
                    <i class="bi bi-exclamation-triangle"></i> <?php echo htmlspecialchars($error_message); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            
            <!-- Privacy Settings -->
            <div class="card settings-card" id="privacy">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-shield-lock-fill"></i> Privacy Settings</h5>
                </div>
                <div class="card-body">
                    <div class="alert-info-custom">
                        <i class="bi bi-info-circle"></i>
                        <strong>Control your privacy:</strong> Choose what information others can see on your profile.
                    </div>
                    
                    <form method="POST" action="">
                        
                        <!-- Profile Visibility -->
                        <div class="setting-item">
                            <div class="setting-info">
                                <h6>Profile Visibility</h6>
                                <p>Who can see your profile</p>
                            </div>
                            <div>
                                <select class="form-select" name="profile_visibility">
                                    <option value="public" <?php echo ($settings['profile_visibility'] ?? 'public') === 'public' ? 'selected' : ''; ?>>
                                        Public - Everyone
                                    </option>
                                    <option value="friends" <?php echo ($settings['profile_visibility'] ?? '') === 'friends' ? 'selected' : ''; ?>>
                                        Friends Only
                                    </option>
                                    <option value="private" <?php echo ($settings['profile_visibility'] ?? '') === 'private' ? 'selected' : ''; ?>>
                                        Private - Only Me
                                    </option>
                                </select>
                            </div>
                        </div>
                        
                        <!-- Show Phone Number -->
                        <div class="setting-item">
                            <div class="setting-info">
                                <h6>Show Phone Number</h6>
                                <p>Allow others to see your phone number</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="show_phone" id="show_phone"
                                       <?php echo ($settings['show_phone'] ?? 1) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="show_phone"></label>
                            </div>
                        </div>
                        
                        <!-- Show Email -->
                        <div class="setting-item">
                            <div class="setting-info">
                                <h6>Show Email Address</h6>
                                <p>Allow others to see your email</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="show_email" id="show_email"
                                       <?php echo ($settings['show_email'] ?? 1) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="show_email"></label>
                            </div>
                        </div>
                        
                        <!-- Show Location -->
                        <div class="setting-item">
                            <div class="setting-info">
                                <h6>Show Location</h6>
                                <p>Display your detailed location</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="show_location" id="show_location"
                                       <?php echo ($settings['show_location'] ?? 1) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="show_location"></label>
                            </div>
                        </div>
                        
                        <!-- Show Birthday -->
                        <div class="setting-item">
                            <div class="setting-info">
                                <h6>Show Birthday</h6>
                                <p>Display your date of birth</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="show_birthday" id="show_birthday"
                                       <?php echo ($settings['show_birthday'] ?? 0) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="show_birthday"></label>
                            </div>
                        </div>
                        
                        <!-- Allow Messages -->
                        <div class="setting-item">
                            <div class="setting-info">
                                <h6>Allow Messages</h6>
                                <p>Let others send you messages</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="allow_messages" id="allow_messages"
                                       <?php echo ($settings['allow_messages'] ?? 1) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="allow_messages"></label>
                            </div>
                        </div>
                        
                        <!-- Allow Friend Requests -->
                        <div class="setting-item">
                            <div class="setting-info">
                                <h6>Allow Friend Requests</h6>
                                <p>Let others send you friend requests</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="allow_friend_requests" id="allow_friend_requests"
                                       <?php echo ($settings['allow_friend_requests'] ?? 1) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="allow_friend_requests"></label>
                            </div>
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" name="update_privacy" class="btn btn-primary">
                                <i class="bi bi-check-circle"></i> Save Privacy Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Notification Preferences -->
            <div class="card settings-card" id="notifications">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-bell-fill"></i> Notification Preferences</h5>
                </div>
                <div class="card-body">
                    <div class="alert-info-custom">
                        <i class="bi bi-info-circle"></i>
                        <strong>Manage notifications:</strong> Choose how you want to be notified about activity.
                    </div>
                    
                    <form method="POST" action="">
                        
                        <!-- Email Notifications -->
                        <div class="setting-item">
                            <div class="setting-info">
                                <h6><i class="bi bi-envelope"></i> Email Notifications</h6>
                                <p>Receive notifications via email</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="email_notifications" id="email_notifications"
                                       <?php echo ($settings['email_notifications'] ?? 1) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="email_notifications"></label>
                            </div>
                        </div>
                        
                        <!-- SMS Notifications -->
                        <div class="setting-item">
                            <div class="setting-info">
                                <h6><i class="bi bi-chat-dots"></i> SMS Notifications</h6>
                                <p>Receive notifications via SMS</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="sms_notifications" id="sms_notifications"
                                       <?php echo ($settings['sms_notifications'] ?? 1) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="sms_notifications"></label>
                            </div>
                        </div>
                        
                        <!-- Push Notifications -->
                        <div class="setting-item">
                            <div class="setting-info">
                                <h6><i class="bi bi-bell"></i> Push Notifications</h6>
                                <p>Receive browser push notifications</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="push_notifications" id="push_notifications"
                                       <?php echo ($settings['push_notifications'] ?? 1) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="push_notifications"></label>
                            </div>
                        </div>
                        
                        <hr class="my-3">
                        
                        <h6 class="mb-3">Notification Types</h6>
                        
                        <!-- Friend Request Notifications -->
                        <div class="setting-item">
                            <div class="setting-info">
                                <h6>Friend Requests</h6>
                                <p>When someone sends you a friend request</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="friend_request_notifications" id="friend_request_notifications"
                                       <?php echo ($settings['friend_request_notifications'] ?? 1) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="friend_request_notifications"></label>
                            </div>
                        </div>
                        
                        <!-- Message Notifications -->
                        <div class="setting-item">
                            <div class="setting-info">
                                <h6>Messages</h6>
                                <p>When you receive a new message</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="message_notifications" id="message_notifications"
                                       <?php echo ($settings['message_notifications'] ?? 1) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="message_notifications"></label>
                            </div>
                        </div>
                        
                        <!-- Post Notifications -->
                        <div class="setting-item">
                            <div class="setting-info">
                                <h6>Posts & Activity</h6>
                                <p>When there's activity on your posts</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="post_notifications" id="post_notifications"
                                       <?php echo ($settings['post_notifications'] ?? 1) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="post_notifications"></label>
                            </div>
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" name="update_notifications" class="btn btn-primary">
                                <i class="bi bi-check-circle"></i> Save Notification Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Account Settings -->
            <div class="card settings-card" id="account">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-person-gear-fill"></i> Account Settings</h5>
                </div>
                <div class="card-body">
                    
                    <!-- Change Password -->
                    <div class="setting-item">
                        <div class="setting-info">
                            <h6>Change Password</h6>
                            <p>Update your account password</p>
                        </div>
                        <div>
                            <a href="<?php echo APP_URL; ?>/auth/change-password.php" class="btn btn-outline-primary btn-sm">
                                Change Password
                            </a>
                        </div>
                    </div>
                    
                    <!-- Two-Factor Authentication -->
                    <div class="setting-item">
                        <div class="setting-info">
                            <h6>Two-Factor Authentication</h6>
                            <p>Add an extra layer of security to your account</p>
                        </div>
                        <div>
                            <button class="btn btn-outline-secondary btn-sm" disabled>
                                Coming Soon
                            </button>
                        </div>
                    </div>
                    
                    <!-- Download Data -->
                    <div class="setting-item">
                        <div class="setting-info">
                            <h6>Download Your Data</h6>
                            <p>Get a copy of your profile data</p>
                        </div>
                        <div>
                            <a href="<?php echo APP_URL; ?>/profile/ajax/download-data.php" class="btn btn-outline-info btn-sm">
                                <i class="bi bi-download"></i> Download
                            </a>
                        </div>
                    </div>
                    
                    <!-- Deactivate Account -->
                    <div class="setting-item">
                        <div class="setting-info">
                            <h6>Deactivate Account</h6>
                            <p>Temporarily deactivate your account</p>
                        </div>
                        <div>
                            <button class="btn btn-outline-warning btn-sm" onclick="alert('Contact support to deactivate your account')">
                                Deactivate
                            </button>
                        </div>
                    </div>
                    
                    <!-- Delete Account -->
                    <div class="setting-item border-danger">
                        <div class="setting-info">
                            <h6 class="text-danger">Delete Account</h6>
                            <p class="text-danger">Permanently delete your account and all data</p>
                        </div>
                        <div>
                            <button class="btn btn-outline-danger btn-sm" 
                                    onclick="if(confirm('This action cannot be undone. Delete your account?')) alert('Contact support to delete your account')">
                                Delete Account
                            </button>
                        </div>
                    </div>
                    
                </div>
            </div>
            
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script>
// Smooth scroll for side navigation
$('.nav-link').on('click', function(e) {
    if ($(this).attr('href').startsWith('#')) {
        e.preventDefault();
        const target = $(this).attr('href');
        $('html, body').animate({
            scrollTop: $(target).offset().top - 80
        }, 500);
        $('.nav-link').removeClass('active');
        $(this).addClass('active');
    }
});

// Update active link on scroll
$(window).on('scroll', function() {
    let current = '';
    $('div[id]').each(function() {
        const sectionTop = $(this).offset().top;
        if ($(window).scrollTop() >= sectionTop - 100) {
            current = $(this).attr('id');
        }
    });
    $('.nav-link').removeClass('active');
    $('.nav-link[href="#' + current + '"]').addClass('active');
});
</script>

<?php
include_once __DIR__ . '/../includes/footer.php';
?>