<?php
/**
 * ============================================================================
 * posts/index.php - Social Feed Page
 * ============================================================================
 */
define('AIMS_ACCESS', true);
require_once __DIR__ . '/../config/config.php';

requireLogin();

$pageTitle = 'Feed';
$userId = getUserId();

// Get database connection
$database = new Database();
$db = $database->getConnection();

$postClass = new \App\Post($db);

// Get posts
$posts = $postClass->getFeed($userId);

include_once __DIR__ . '/../includes/meta.php';
include_once __DIR__ . '/../includes/header.php';
?>

<style>
.create-post-card {
    border-radius: 10px;
    margin-bottom: 20px;
}

.post-card {
    border-radius: 10px;
    margin-bottom: 20px;
    transition: box-shadow 0.3s;
}

.post-card:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.post-header {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 15px;
}

.post-avatar {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    object-fit: cover;
}

.post-images {
    display: grid;
    gap: 5px;
    margin: 15px 0;
}

.post-images.single {
    grid-template-columns: 1fr;
}

.post-images.double {
    grid-template-columns: repeat(2, 1fr);
}

.post-images.multiple {
    grid-template-columns: repeat(3, 1fr);
}

.post-images img {
    width: 100%;
    height: 250px;
    object-fit: cover;
    border-radius: 8px;
    cursor: pointer;
}

.post-actions {
    display: flex;
    justify-content: space-around;
    padding: 10px 0;
    border-top: 1px solid #dee2e6;
    border-bottom: 1px solid #dee2e6;
}

.post-action-btn {
    background: none;
    border: none;
    color: #6c757d;
    cursor: pointer;
    padding: 5px 15px;
    transition: color 0.3s;
}

.post-action-btn:hover {
    color: #0d6efd;
}

.post-action-btn.liked {
    color: #dc3545;
}

.comment-section {
    margin-top: 15px;
}

.comment {
    display: flex;
    gap: 10px;
    margin-bottom: 15px;
}

.comment-avatar {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    object-fit: cover;
}

.comment-content {
    flex: 1;
    background: #f1f3f5;
    padding: 10px 15px;
    border-radius: 18px;
}

.comment-author {
    font-weight: 600;
    font-size: 0.9rem;
}

.comment-text {
    margin-top: 5px;
    font-size: 0.9rem;
}

.comment-time {
    font-size: 0.75rem;
    color: #6c757d;
    margin-top: 5px;
}
</style>

<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-lg-6 col-md-8">
            <!-- Create Post Card -->
            <div class="card border-0 shadow-sm create-post-card">
                <div class="card-body">
                    <div class="d-flex gap-2">
                        <img src="<?php echo getAvatarUrl($_SESSION['profile_picture']); ?>" 
                             class="rounded-circle" 
                             width="40" height="40"
                             alt="<?php echo htmlspecialchars(getUserName()); ?>">
                        <button class="btn btn-light flex-grow-1 text-start" 
                                data-bs-toggle="modal" 
                                data-bs-target="#createPostModal">
                            What's on your mind, <?php echo htmlspecialchars(explode(' ', getUserName())[0]); ?>?
                        </button>
                    </div>
                    
                    <hr>
                    
                    <div class="d-flex justify-content-around">
                        <button class="btn btn-link text-decoration-none" 
                                onclick="openCreatePost('image')">
                            <i class="bi bi-image text-success"></i> Photo
                        </button>
                        <button class="btn btn-link text-decoration-none" 
                                onclick="openCreatePost('tip')">
                            <i class="bi bi-lightbulb text-warning"></i> Tip
                        </button>
                        <button class="btn btn-link text-decoration-none" 
                                onclick="openCreatePost('text')">
                            <i class="bi bi-pencil text-primary"></i> Post
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- Posts Feed -->
            <?php if (empty($posts)): ?>
                <div class="card border-0 shadow-sm text-center py-5">
                    <div class="card-body">
                        <i class="bi bi-inbox" style="font-size: 4rem; color: #dee2e6;"></i>
                        <h5 class="mt-3">No Posts Yet</h5>
                        <p class="text-muted">Start following farmers or create your first post!</p>
                        <a href="<?php echo APP_URL; ?>/friends/find-farmers.php" class="btn btn-primary">
                            Find Farmers
                        </a>
                    </div>
                </div>
            <?php else: ?>
                <?php foreach ($posts as $post): ?>
                    <?php include __DIR__ . '/post-card.php'; ?>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Create Post Modal -->
<div class="modal fade" id="createPostModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create Post</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="createPostForm" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="mb-3">
                        <textarea class="form-control" 
                                  name="content" 
                                  rows="4" 
                                  placeholder="What's on your mind?"
                                  required></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Visibility</label>
                        <select class="form-select" name="visibility">
                            <option value="public">Public</option>
                            <option value="friends">Friends Only</option>
                            <option value="private">Only Me</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Add Photos (Optional)</label>
                        <input type="file" 
                               class="form-control" 
                               name="images[]" 
                               multiple 
                               accept="image/*">
                        <small class="text-muted">You can select multiple images</small>
                    </div>
                    
                    <div id="imagePreview" class="d-flex gap-2 flex-wrap"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-send"></i> Post
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function openCreatePost(type) {
    $('#createPostModal').modal('show');
}

// Preview images before upload
$('input[name="images[]"]').on('change', function() {
    const files = this.files;
    const preview = $('#imagePreview');
    preview.html('');
    
    if (files.length > 0) {
        for (let i = 0; i < files.length && i < 10; i++) {
            const reader = new FileReader();
            reader.onload = function(e) {
                preview.append(`
                    <img src="${e.target.result}" 
                         class="img-thumbnail" 
                         style="width: 100px; height: 100px; object-fit: cover;">
                `);
            };
            reader.readAsDataURL(files[i]);
        }
    }
});

// Handle post creation
$('#createPostForm').on('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    $.ajax({
        url: '<?php echo APP_URL; ?>/posts/create.php',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            if (response.success) {
                location.reload();
            } else {
                alert('Failed to create post: ' + (response.error || 'Unknown error'));
            }
        },
        error: function() {
            alert('Error creating post');
        }
    });
});

// Handle like button
function toggleLike(postId) {
    $.ajax({
        url: '<?php echo APP_URL; ?>/posts/toggle-like.php',
        type: 'POST',
        data: { post_id: postId },
        success: function(response) {
            if (response.success) {
                location.reload();
            }
        }
    });
}

// Handle comment submission
function submitComment(postId) {
    const commentInput = $(`#commentInput${postId}`);
    const content = commentInput.val().trim();
    
    if (!content) return;
    
    $.ajax({
        url: '<?php echo APP_URL; ?>/posts/add-comment.php',
        type: 'POST',
        data: {
            post_id: postId,
            content: content
        },
        success: function(response) {
            if (response.success) {
                location.reload();
            } else {
                alert('Failed to add comment');
            }
        },
        error: function() {
            alert('Error adding comment');
        }
    });
}
</script>

<?php
include_once __DIR__ . '/../includes/footer.php';
include_once __DIR__ . '/../includes/bottom-nav.php';
?>